"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.postConnectorConfiguration = exports.ConnectorConfigurationApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../api_logic/create_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const postConnectorConfiguration = async ({
  configuration,
  connectorId,
  http
}) => {
  const route = `/internal/content_connectors/connectors/${connectorId}/configuration`;
  const responseConfig = await (http === null || http === void 0 ? void 0 : http.post(route, {
    body: JSON.stringify(configuration)
  }));
  return {
    configuration: responseConfig
  };
};
exports.postConnectorConfiguration = postConnectorConfiguration;
const ConnectorConfigurationApiLogic = exports.ConnectorConfigurationApiLogic = (0, _create_api_logic.createApiLogic)(['content', 'configuration_connector_api_logic'], postConnectorConfiguration, {
  showSuccessFlashFn: () => _i18n.i18n.translate('xpack.contentConnectors.content.indices.configurationConnector.configuration.successToast.title', {
    defaultMessage: 'Configuration updated'
  })
});