"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FindingsVulnerabilityFlyoutContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _vulnerability_json_tab = require("../vulnerability_json_tab");
var _vulnerability_overview_tab = require("../vulnerability_overview_tab");
var _vulnerability_table_tab = require("../vulnerability_table_tab");
var _test_subjects = require("../../test_subjects");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const overviewTabId = 'vuln-flyout-overview-tab';
const tableTabId = 'vuln-flyout-table-tab';
const jsonTabId = 'vuln-flyout-json-tab';
const FindingsVulnerabilityFlyoutContent = ({
  finding
}) => {
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(overviewTabId);
  const tabs = (0, _react.useMemo)(() => [{
    id: overviewTabId,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.vulnerabilities.vulnerabilityFindingFlyout.overviewTabLabel",
      defaultMessage: "Overview"
    }),
    content: /*#__PURE__*/_react.default.createElement(_vulnerability_overview_tab.VulnerabilityOverviewTab, {
      vulnerabilityRecord: finding
    })
  }, {
    id: tableTabId,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.vulnerabilities.vulnerabilityFindingFlyout.tableTabLabel",
      defaultMessage: "Table"
    }),
    content: /*#__PURE__*/_react.default.createElement(_vulnerability_table_tab.VulnerabilityTableTab, {
      vulnerabilityRecord: finding
    })
  }, {
    id: jsonTabId,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.vulnerabilities.vulnerabilityFindingFlyout.jsonTabLabel",
      defaultMessage: "JSON"
    }),
    content: /*#__PURE__*/_react.default.createElement(_vulnerability_json_tab.VulnerabilityJsonTab, {
      vulnerabilityRecord: finding
    })
  }], [finding]);
  const onSelectedTabChanged = id => setSelectedTabId(id);
  const selectedTabContent = (0, _react.useMemo)(() => {
    var _tabs$find;
    return (_tabs$find = tabs.find(obj => obj.id === selectedTabId)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content;
  }, [selectedTabId, tabs]);
  const renderTabs = () => tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": (0, _test_subjects.TAB_ID_VULNERABILITY_FLYOUT)(tab.id),
    onClick: () => onSelectedTabChanged(tab.id),
    isSelected: tab.id === selectedTabId,
    key: index
  }, tab.name));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    expand: true
  }, renderTabs()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, selectedTabContent));
};

// eslint-disable-next-line import/no-default-export
exports.FindingsVulnerabilityFlyoutContent = FindingsVulnerabilityFlyoutContent;
var _default = exports.default = FindingsVulnerabilityFlyoutContent;