"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleList = exports.RuleTab = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _rules_detection_rule_counter = require("../../rules/rules_detection_rule_counter");
var _findings_flyout = require("./findings_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getReferenceFromRule = rule => {
  return (rule === null || rule === void 0 ? void 0 : rule.reference) || (rule === null || rule === void 0 ? void 0 : rule.references);
};
const getRuleList = (rule, ruleState = 'unmuted', ruleFlyoutLink) => {
  var _rule$benchmark, _rule$tags, _rule$benchmark2, _rule$benchmark3, _rule$benchmark4;
  const reference = getReferenceFromRule(rule);
  return [{
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.nameTitle', {
      defaultMessage: 'Name'
    }),
    description: rule !== null && rule !== void 0 && rule.name ? /*#__PURE__*/_react.default.createElement(_findings_flyout.RuleNameLink, {
      ruleFlyoutLink: ruleFlyoutLink,
      ruleName: rule.name
    }) : _findings_flyout.EMPTY_VALUE
  }, {
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.descriptionTitle', {
      defaultMessage: 'Description'
    }),
    description: rule !== null && rule !== void 0 && rule.description ? /*#__PURE__*/_react.default.createElement(_findings_flyout.CspFlyoutMarkdown, null, rule.description) : _findings_flyout.EMPTY_VALUE
  }, {
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.AlertsTitle', {
      defaultMessage: 'Alerts'
    }),
    description: ruleState === 'muted' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.findings.findingsFlyout.ruleTab.disabledRuleText",
      defaultMessage: "Disabled"
    }) : rule !== null && rule !== void 0 && (_rule$benchmark = rule.benchmark) !== null && _rule$benchmark !== void 0 && _rule$benchmark.name ? /*#__PURE__*/_react.default.createElement(_rules_detection_rule_counter.RulesDetectionRuleCounter, {
      benchmarkRule: rule
    }) : _findings_flyout.EMPTY_VALUE
  }, {
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.tagsTitle', {
      defaultMessage: 'Tags'
    }),
    description: rule !== null && rule !== void 0 && (_rule$tags = rule.tags) !== null && _rule$tags !== void 0 && _rule$tags.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, rule.tags.map(tag => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      key: tag
    }, tag))) : _findings_flyout.EMPTY_VALUE
  }, {
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.frameworkSourcesTitle', {
      defaultMessage: 'Framework Sources'
    }),
    description: rule !== null && rule !== void 0 && (_rule$benchmark2 = rule.benchmark) !== null && _rule$benchmark2 !== void 0 && _rule$benchmark2.id && rule !== null && rule !== void 0 && (_rule$benchmark3 = rule.benchmark) !== null && _rule$benchmark3 !== void 0 && _rule$benchmark3.name ? /*#__PURE__*/_react.default.createElement(_findings_flyout.BenchmarkIcons, {
      benchmarkId: rule.benchmark.id,
      benchmarkName: rule.benchmark.name
    }) : _findings_flyout.EMPTY_VALUE
  }, {
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.cisSectionTitle', {
      defaultMessage: 'Framework Section'
    }),
    description: (rule === null || rule === void 0 ? void 0 : rule.section) || _findings_flyout.EMPTY_VALUE
  }, {
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.profileApplicabilityTitle', {
      defaultMessage: 'Profile Applicability'
    }),
    description: rule !== null && rule !== void 0 && rule.profile_applicability ? /*#__PURE__*/_react.default.createElement(_findings_flyout.CspFlyoutMarkdown, null, rule.profile_applicability) : _findings_flyout.EMPTY_VALUE
  }, {
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.benchmarkTitle', {
      defaultMessage: 'Benchmark'
    }),
    description: (rule === null || rule === void 0 ? void 0 : (_rule$benchmark4 = rule.benchmark) === null || _rule$benchmark4 === void 0 ? void 0 : _rule$benchmark4.name) || _findings_flyout.EMPTY_VALUE
  }, {
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.auditTitle', {
      defaultMessage: 'Audit'
    }),
    description: rule !== null && rule !== void 0 && rule.audit ? /*#__PURE__*/_react.default.createElement(_findings_flyout.CspFlyoutMarkdown, null, rule.audit) : _findings_flyout.EMPTY_VALUE
  }, {
    title: _i18n.i18n.translate('xpack.csp.findings.findingsFlyout.ruleTab.referencesTitle', {
      defaultMessage: 'References'
    }),
    description: reference ? /*#__PURE__*/_react.default.createElement(_findings_flyout.CspFlyoutMarkdown, null, reference) : _findings_flyout.EMPTY_VALUE
  }];
};
exports.getRuleList = getRuleList;
const RuleTab = ({
  data,
  ruleFlyoutLink
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: getRuleList(data.rule, ruleFlyoutLink)
  });
};
exports.RuleTab = RuleTab;