"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMobileFilters = getMobileFilters;
var _mobile_types = require("../../../common/mobile_types");
var _get_device_os_app = require("./get_device_os_app");
var _get_nct = require("./get_nct");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getMobileFilters({
  kuery,
  apmEventClient,
  serviceName,
  transactionType,
  environment,
  start,
  end
}) {
  var _mobileTransactionEve, _mobileTransactionEve2, _mobileTransactionEve3, _mobileTransactionEve4, _mobileTransactionEve5, _mobileTransactionEve6, _mobileTransactionEve7, _mobileTransactionEve8, _mobileTransactionEve9, _mobileNetworkConnect, _mobileNetworkConnect2, _mobileNetworkConnect3;
  const MAX_ITEMS = 10;
  const commonProps = {
    kuery,
    apmEventClient,
    serviceName,
    transactionType,
    environment,
    start,
    end,
    size: MAX_ITEMS
  };
  const [mobileTransactionEventsFiltersResponse, mobileNetworkConnectionTypeFiltersResponse] = await Promise.all([(0, _get_device_os_app.getDeviceOSApp)(commonProps), (0, _get_nct.getNCT)(commonProps)]);
  return [{
    key: _mobile_types.MobileProperty.Device,
    options: ((_mobileTransactionEve = mobileTransactionEventsFiltersResponse.aggregations) === null || _mobileTransactionEve === void 0 ? void 0 : (_mobileTransactionEve2 = _mobileTransactionEve.devices) === null || _mobileTransactionEve2 === void 0 ? void 0 : (_mobileTransactionEve3 = _mobileTransactionEve2.buckets) === null || _mobileTransactionEve3 === void 0 ? void 0 : _mobileTransactionEve3.map(({
      key
    }) => key)) || []
  }, {
    key: _mobile_types.MobileProperty.OsVersion,
    options: ((_mobileTransactionEve4 = mobileTransactionEventsFiltersResponse.aggregations) === null || _mobileTransactionEve4 === void 0 ? void 0 : (_mobileTransactionEve5 = _mobileTransactionEve4.osVersions) === null || _mobileTransactionEve5 === void 0 ? void 0 : (_mobileTransactionEve6 = _mobileTransactionEve5.buckets) === null || _mobileTransactionEve6 === void 0 ? void 0 : _mobileTransactionEve6.map(({
      key
    }) => key)) || []
  }, {
    key: _mobile_types.MobileProperty.AppVersion,
    options: ((_mobileTransactionEve7 = mobileTransactionEventsFiltersResponse.aggregations) === null || _mobileTransactionEve7 === void 0 ? void 0 : (_mobileTransactionEve8 = _mobileTransactionEve7.appVersions) === null || _mobileTransactionEve8 === void 0 ? void 0 : (_mobileTransactionEve9 = _mobileTransactionEve8.buckets) === null || _mobileTransactionEve9 === void 0 ? void 0 : _mobileTransactionEve9.map(({
      key
    }) => key)) || []
  }, {
    key: _mobile_types.MobileProperty.NetworkConnectionType,
    options: ((_mobileNetworkConnect = mobileNetworkConnectionTypeFiltersResponse.aggregations) === null || _mobileNetworkConnect === void 0 ? void 0 : (_mobileNetworkConnect2 = _mobileNetworkConnect.netConnectionTypes) === null || _mobileNetworkConnect2 === void 0 ? void 0 : (_mobileNetworkConnect3 = _mobileNetworkConnect2.buckets) === null || _mobileNetworkConnect3 === void 0 ? void 0 : _mobileNetworkConnect3.map(({
      key
    }) => key)) || []
  }];
}