/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene.read;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.DocBlock;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.OrdinalBytesRefBlock;
import org.elasticsearch.compute.data.OrdinalBytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.ShardContext;
import org.elasticsearch.compute.lucene.read.DelegatingBlockLoaderFactory;
import org.elasticsearch.compute.lucene.read.ValuesSourceReaderOperator;
import org.elasticsearch.compute.operator.AbstractPageMappingOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockLoaderStoredFieldsFromLeafLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.search.fetch.StoredFieldsSpec;

public class TimeSeriesExtractFieldOperator
extends AbstractPageMappingOperator {
    private final BlockFactory blockFactory;
    private final List<ValuesSourceReaderOperator.FieldInfo> fields;
    private final List<? extends ShardContext> shardContexts;
    private ShardLevelFieldsReader fieldsReader;

    public TimeSeriesExtractFieldOperator(BlockFactory blockFactory, List<ValuesSourceReaderOperator.FieldInfo> fields, List<? extends ShardContext> shardContexts) {
        this.blockFactory = blockFactory;
        this.fields = fields;
        this.shardContexts = shardContexts;
    }

    private OrdinalBytesRefVector getTsid(Page page, int channel) {
        BytesRefBlock block = (BytesRefBlock)page.getBlock(channel);
        OrdinalBytesRefBlock ordinals = block.asOrdinals();
        if (ordinals == null) {
            throw new IllegalArgumentException("tsid must be an ordinals block, got: " + block.getClass().getName());
        }
        OrdinalBytesRefVector vector = ordinals.asVector();
        if (vector == null) {
            throw new IllegalArgumentException("tsid must be an ordinals vector, got: " + block.getClass().getName());
        }
        return vector;
    }

    private DocVector getDocVector(Page page, int channel) {
        DocBlock docBlock = (DocBlock)page.getBlock(channel);
        DocVector docVector = docBlock.asVector();
        if (docVector == null) {
            throw new IllegalArgumentException("doc must be a doc vector, got: " + docBlock.getClass().getName());
        }
        return docVector;
    }

    @Override
    protected Page process(Page page) {
        try {
            return this.processUnchecked(page);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page processUnchecked(Page page) throws IOException {
        DocVector docVector = this.getDocVector(page, 0);
        IntVector shards = docVector.shards();
        if (!shards.isConstant()) {
            throw new IllegalArgumentException("shards must be a constant vector, got: " + shards.getClass().getName());
        }
        OrdinalBytesRefVector tsidVector = this.getTsid(page, 1);
        IntVector tsidOrdinals = tsidVector.getOrdinalsVector();
        int shardIndex = shards.getInt(0);
        if (this.fieldsReader == null || this.fieldsReader.shardIndex != shardIndex) {
            Releasables.close((Releasable)this.fieldsReader);
            this.fieldsReader = new ShardLevelFieldsReader(shardIndex, this.blockFactory, this.shardContexts.get(shardIndex), this.fields);
        }
        this.fieldsReader.prepareForReading(page.getPositionCount());
        IntVector docs = docVector.docs();
        IntVector segments = docVector.segments();
        int lastTsidOrdinal = -1;
        for (int p = 0; p < docs.getPositionCount(); ++p) {
            int doc = docs.getInt(p);
            int segment = segments.getInt(p);
            int tsidOrd = tsidOrdinals.getInt(p);
            if (tsidOrd == lastTsidOrdinal) {
                this.fieldsReader.readValues(segment, doc, true);
                continue;
            }
            this.fieldsReader.readValues(segment, doc, false);
            lastTsidOrdinal = tsidOrd;
        }
        Releasable[] blocks = new Block[this.fields.size()];
        Page result = null;
        try {
            this.fieldsReader.buildBlocks((Block[])blocks, tsidOrdinals);
            Page page2 = result = page.appendBlocks((Block[])blocks);
            return page2;
        }
        finally {
            if (result == null) {
                Releasables.close((Releasable[])blocks);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TimeSeriesExtractFieldOperator[fields = [");
        if (this.fields.size() < 10) {
            boolean first = true;
            for (ValuesSourceReaderOperator.FieldInfo f : this.fields) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(f.name());
            }
        } else {
            sb.append(this.fields.size()).append(" fields");
        }
        return sb.append("]]").toString();
    }

    @Override
    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.fieldsReader, () -> super.close()});
    }

    static final class ShardLevelFieldsReader
    implements Releasable {
        final int shardIndex;
        private final BlockLoaderFactory blockFactory;
        private final SegmentLevelFieldsReader[] segments;
        private final BlockLoader[] loaders;
        private final boolean[] dimensions;
        private final Block.Builder[] builders;
        private final StoredFieldsSpec storedFieldsSpec;
        private final SourceLoader sourceLoader;

        ShardLevelFieldsReader(int shardIndex, BlockFactory blockFactory, ShardContext shardContext, List<ValuesSourceReaderOperator.FieldInfo> fields) {
            int i;
            this.shardIndex = shardIndex;
            this.blockFactory = new BlockLoaderFactory(blockFactory);
            IndexReader indexReader = shardContext.searcher().getIndexReader();
            this.segments = new SegmentLevelFieldsReader[indexReader.leaves().size()];
            this.loaders = new BlockLoader[fields.size()];
            this.builders = new Block.Builder[this.loaders.length];
            StoredFieldsSpec storedFieldsSpec = StoredFieldsSpec.NO_REQUIREMENTS;
            for (i = 0; i < fields.size(); ++i) {
                BlockLoader loader = fields.get(i).blockLoader().apply(shardIndex);
                storedFieldsSpec = storedFieldsSpec.merge(loader.rowStrideStoredFieldSpec());
                this.loaders[i] = loader;
            }
            for (i = 0; i < indexReader.leaves().size(); ++i) {
                LeafReaderContext leafReaderContext = (LeafReaderContext)indexReader.leaves().get(i);
                this.segments[i] = new SegmentLevelFieldsReader(leafReaderContext, this.loaders);
            }
            if (storedFieldsSpec.requiresSource()) {
                this.sourceLoader = shardContext.newSourceLoader();
                storedFieldsSpec = storedFieldsSpec.merge(new StoredFieldsSpec(false, false, this.sourceLoader.requiredStoredFields()));
            } else {
                this.sourceLoader = null;
            }
            this.storedFieldsSpec = storedFieldsSpec;
            this.dimensions = new boolean[fields.size()];
            for (i = 0; i < fields.size(); ++i) {
                this.dimensions[i] = shardContext.fieldType(fields.get(i).name()).isDimension();
            }
        }

        void readValues(int segment, int docID, boolean nonDimensionFieldsOnly) throws IOException {
            this.segments[segment].read(docID, this.builders, nonDimensionFieldsOnly, this.dimensions);
        }

        void prepareForReading(int estimatedSize) throws IOException {
            if (this.builders.length > 0 && this.builders[0] == null) {
                for (int f = 0; f < this.builders.length; ++f) {
                    this.builders[f] = (Block.Builder)this.loaders[f].builder((BlockLoader.BlockFactory)this.blockFactory, estimatedSize);
                }
            }
            for (SegmentLevelFieldsReader segment : this.segments) {
                segment.reinitializeIfNeeded(this.sourceLoader, this.storedFieldsSpec);
            }
        }

        void buildBlocks(Block[] blocks, IntVector tsidOrdinals) {
            for (int i = 0; i < this.builders.length; ++i) {
                blocks[i] = this.dimensions[i] ? this.buildBlockForDimensionField(this.builders[i], tsidOrdinals) : this.builders[i].build();
            }
            Arrays.fill(this.builders, null);
        }

        private Block buildBlockForDimensionField(Block.Builder builder, IntVector tsidOrdinals) {
            try (Block values = builder.build();){
                Block block;
                block17: {
                    Object object = values.asVector();
                    if (object instanceof BytesRefVector) {
                        BytesRefVector bytes = (BytesRefVector)object;
                        tsidOrdinals.incRef();
                        values.incRef();
                        object = new OrdinalBytesRefVector(tsidOrdinals, bytes).asBlock();
                        return object;
                    }
                    if (values.areAllValuesNull()) {
                        object = this.blockFactory.factory.newConstantNullBlock(tsidOrdinals.getPositionCount());
                        return object;
                    }
                    int positionCount = tsidOrdinals.getPositionCount();
                    Block.Builder newBuilder = values.elementType().newBlockBuilder(positionCount, this.blockFactory.factory);
                    try {
                        for (int p = 0; p < positionCount; ++p) {
                            int pos = tsidOrdinals.getInt(p);
                            newBuilder.copyFrom(values, pos, pos + 1);
                        }
                        block = newBuilder.build();
                        if (newBuilder == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (newBuilder != null) {
                            try {
                                newBuilder.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    newBuilder.close();
                }
                return block;
            }
        }

        public void close() {
            Releasables.close((Releasable[])this.builders);
        }
    }

    static final class SegmentLevelFieldsReader {
        private final BlockLoader.RowStrideReader[] rowStride;
        private final BlockLoader[] loaders;
        private final LeafReaderContext leafContext;
        private BlockLoaderStoredFieldsFromLeafLoader storedFields;
        private Thread loadedThread = null;

        SegmentLevelFieldsReader(LeafReaderContext leafContext, BlockLoader[] loaders) {
            this.leafContext = leafContext;
            this.loaders = loaders;
            this.rowStride = new BlockLoader.RowStrideReader[loaders.length];
        }

        private void reinitializeIfNeeded(SourceLoader sourceLoader, StoredFieldsSpec storedFieldsSpec) throws IOException {
            Thread currentThread = Thread.currentThread();
            if (this.loadedThread != currentThread) {
                this.loadedThread = currentThread;
                for (int f = 0; f < this.loaders.length; ++f) {
                    this.rowStride[f] = this.loaders[f].rowStrideReader(this.leafContext);
                }
                this.storedFields = new BlockLoaderStoredFieldsFromLeafLoader(StoredFieldLoader.fromSpec((StoredFieldsSpec)storedFieldsSpec).getLoader(this.leafContext, null), sourceLoader != null ? sourceLoader.leaf(this.leafContext.reader(), null) : null);
            }
        }

        void read(int docId, Block.Builder[] builder, boolean nonDimensionFieldsOnly, boolean[] dimensions) throws IOException {
            this.storedFields.advanceTo(docId);
            if (nonDimensionFieldsOnly) {
                for (int i = 0; i < this.rowStride.length; ++i) {
                    if (dimensions[i]) continue;
                    this.rowStride[i].read(docId, (BlockLoader.StoredFields)this.storedFields, (BlockLoader.Builder)builder[i]);
                }
            } else {
                for (int i = 0; i < this.rowStride.length; ++i) {
                    this.rowStride[i].read(docId, (BlockLoader.StoredFields)this.storedFields, (BlockLoader.Builder)builder[i]);
                }
            }
        }
    }

    static class BlockLoaderFactory
    extends DelegatingBlockLoaderFactory {
        BlockLoaderFactory(BlockFactory factory) {
            super(factory);
        }

        public BlockLoader.Block constantNulls(int count) {
            throw new UnsupportedOperationException("must not be used by column readers");
        }

        public BlockLoader.Block constantBytes(BytesRef value, int count) {
            throw new UnsupportedOperationException("must not be used by column readers");
        }

        @Override
        public BlockLoader.SingletonOrdinalsBuilder singletonOrdinalsBuilder(SortedDocValues ordinals, int count) {
            throw new UnsupportedOperationException("must not be used by column readers");
        }
    }

    public record Factory(List<ValuesSourceReaderOperator.FieldInfo> fields, List<? extends ShardContext> shardContexts) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new TimeSeriesExtractFieldOperator(driverContext.blockFactory(), this.fields, this.shardContexts);
        }

        @Override
        public String describe() {
            StringBuilder sb = new StringBuilder();
            sb.append("TimeSeriesExtractFieldOperator[fields = [");
            if (this.fields.size() < 10) {
                boolean first = true;
                for (ValuesSourceReaderOperator.FieldInfo f : this.fields) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(f.name());
                }
            } else {
                sb.append(this.fields.size()).append(" fields");
            }
            return sb.append("]]").toString();
        }
    }
}

