/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.compute.aggregation.AbstractArrayState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class FirstOverTimeIntAggregator {
    public static GroupingState initGrouping(DriverContext driverContext) {
        return new GroupingState(driverContext.bigArrays());
    }

    public static void combine(GroupingState current, int groupId, long timestamp, int value) {
        current.collectValue(groupId, timestamp, value);
    }

    public static void combineIntermediate(GroupingState current, int groupId, LongBlock timestamps, IntBlock values, int otherPosition) {
        int valueCount = values.getValueCount(otherPosition);
        if (valueCount > 0) {
            long timestamp = timestamps.getLong(timestamps.getFirstValueIndex(otherPosition));
            int firstIndex = values.getFirstValueIndex(otherPosition);
            for (int i = 0; i < valueCount; ++i) {
                current.collectValue(groupId, timestamp, values.getInt(firstIndex + i));
            }
        }
    }

    public static void combineStates(GroupingState current, int currentGroupId, GroupingState otherState, int otherGroupId) {
        if ((long)otherGroupId < otherState.timestamps.size() && otherState.hasValue(otherGroupId)) {
            long timestamp = otherState.timestamps.get((long)otherGroupId);
            int value = otherState.values.get((long)otherGroupId);
            current.collectValue(currentGroupId, timestamp, value);
        }
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, GroupingAggregatorEvaluationContext evalContext) {
        return state.evaluateFinal(selected, evalContext);
    }

    public static final class GroupingState
    extends AbstractArrayState {
        private final BigArrays bigArrays;
        private LongArray timestamps;
        private IntArray values;
        private int maxGroupId = -1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        GroupingState(BigArrays bigArrays) {
            super(bigArrays);
            this.bigArrays = bigArrays;
            boolean success = false;
            LongArray timestamps = null;
            try {
                this.timestamps = timestamps = bigArrays.newLongArray(1L, false);
                this.values = bigArrays.newIntArray(1L, false);
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                Releasables.close((Releasable[])new Releasable[]{timestamps, this.values, () -> super.close()});
                throw throwable;
            }
        }

        void collectValue(int groupId, long timestamp, int value) {
            if ((long)groupId < this.timestamps.size()) {
                if (groupId > this.maxGroupId || !this.hasValue(groupId) || this.timestamps.get((long)groupId) > timestamp) {
                    this.timestamps.set((long)groupId, timestamp);
                    this.values.set((long)groupId, value);
                }
            } else {
                this.timestamps = this.bigArrays.grow(this.timestamps, (long)(groupId + 1));
                this.values = this.bigArrays.grow(this.values, (long)(groupId + 1));
                this.timestamps.set((long)groupId, timestamp);
                this.values.set((long)groupId, value);
            }
            this.maxGroupId = Math.max(this.maxGroupId, groupId);
            this.trackGroupId(groupId);
        }

        @Override
        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.timestamps, this.values, () -> super.close()});
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            try (LongBlock.Builder timestampsBuilder = driverContext.blockFactory().newLongBlockBuilder(selected.getPositionCount());
                 IntBlock.Builder valuesBuilder = driverContext.blockFactory().newIntBlockBuilder(selected.getPositionCount());){
                for (int p = 0; p < selected.getPositionCount(); ++p) {
                    int group = selected.getInt(p);
                    if ((long)group < this.timestamps.size() && this.hasValue(group)) {
                        timestampsBuilder.appendLong(this.timestamps.get((long)group));
                        valuesBuilder.appendInt(this.values.get((long)group));
                        continue;
                    }
                    timestampsBuilder.appendNull();
                    valuesBuilder.appendNull();
                }
                blocks[offset] = timestampsBuilder.build();
                blocks[offset + 1] = valuesBuilder.build();
            }
        }

        Block evaluateFinal(IntVector selected, GroupingAggregatorEvaluationContext evalContext) {
            try (IntBlock.Builder builder = evalContext.blockFactory().newIntBlockBuilder(selected.getPositionCount());){
                for (int p = 0; p < selected.getPositionCount(); ++p) {
                    int group = selected.getInt(p);
                    if ((long)group < this.timestamps.size() && this.hasValue(group)) {
                        builder.appendInt(this.values.get((long)group));
                        continue;
                    }
                    builder.appendNull();
                }
                IntBlock intBlock = builder.build();
                return intBlock;
            }
        }
    }
}

