/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es816;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.ReadAdvice;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.lucene.util.hnsw.OrdinalTranslatedKnnCollector;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.elasticsearch.index.codec.vectors.BQVectorUtils;
import org.elasticsearch.index.codec.vectors.es816.BinarizedByteVectorValues;
import org.elasticsearch.index.codec.vectors.es816.BinaryQuantizer;
import org.elasticsearch.index.codec.vectors.es816.ES816BinaryFlatVectorsScorer;
import org.elasticsearch.index.codec.vectors.es816.OffHeapBinarizedVectorValues;
import org.elasticsearch.index.codec.vectors.reflect.OffHeapByteSizeUtils;
import org.elasticsearch.index.codec.vectors.reflect.OffHeapStats;

@SuppressForbidden(reason="Lucene classes")
public class ES816BinaryQuantizedVectorsReader
extends FlatVectorsReader
implements OffHeapStats {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(ES816BinaryQuantizedVectorsReader.class);
    private final Map<String, FieldEntry> fields = new HashMap<String, FieldEntry>();
    private final IndexInput quantizedVectorData;
    private final FlatVectorsReader rawVectorsReader;
    private final ES816BinaryFlatVectorsScorer vectorScorer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ES816BinaryQuantizedVectorsReader(SegmentReadState state, FlatVectorsReader rawVectorsReader, ES816BinaryFlatVectorsScorer vectorsScorer) throws IOException {
        super((FlatVectorsScorer)vectorsScorer);
        this.vectorScorer = vectorsScorer;
        this.rawVectorsReader = rawVectorsReader;
        int versionMeta = -1;
        String metaFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"vemb");
        boolean success = false;
        try {
            try (ChecksumIndexInput meta = state.directory.openChecksumInput(metaFileName);){
                Throwable priorE = null;
                try {
                    versionMeta = CodecUtil.checkIndexHeader((DataInput)meta, (String)"ES816BinaryQuantizedVectorsFormatMeta", (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    this.readFields(meta, state.fieldInfos);
                }
                catch (Throwable exception) {
                    priorE = exception;
                }
                finally {
                    CodecUtil.checkFooter((ChecksumIndexInput)meta, (Throwable)priorE);
                }
                this.quantizedVectorData = ES816BinaryQuantizedVectorsReader.openDataInput(state, versionMeta, "veb", "ES816BinaryQuantizedVectorsFormatData", state.context.withReadAdvice(ReadAdvice.RANDOM));
                success = true;
            }
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
    }

    private void readFields(ChecksumIndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, (DataInput)meta);
            }
            FieldEntry fieldEntry = this.readField((IndexInput)meta, info);
            ES816BinaryQuantizedVectorsReader.validateFieldEntry(info, fieldEntry);
            this.fields.put(info.name, fieldEntry);
            fieldNumber = meta.readInt();
        }
    }

    static void validateFieldEntry(FieldInfo info, FieldEntry fieldEntry) {
        int correctionsCount;
        int dimension = info.getVectorDimension();
        if (dimension != fieldEntry.dimension) {
            throw new IllegalStateException("Inconsistent vector dimension for field=\"" + info.name + "\"; " + dimension + " != " + fieldEntry.dimension);
        }
        int binaryDims = BQVectorUtils.discretize(dimension, 64) / 8;
        long numQuantizedVectorBytes = Math.multiplyExact((long)(binaryDims + 4 * (correctionsCount = fieldEntry.similarityFunction != VectorSimilarityFunction.EUCLIDEAN ? 3 : 2)), (long)fieldEntry.size);
        if (numQuantizedVectorBytes != fieldEntry.vectorDataLength) {
            throw new IllegalStateException("Binarized vector data length " + fieldEntry.vectorDataLength + " not matching size = " + fieldEntry.size + " * (binaryBytes=" + binaryDims + " + 8) = " + numQuantizedVectorBytes);
        }
    }

    public RandomVectorScorer getRandomVectorScorer(String field, float[] target) throws IOException {
        FieldEntry fi = this.fields.get(field);
        if (fi == null || fi.size() == 0) {
            return null;
        }
        return this.vectorScorer.getRandomVectorScorer(fi.similarityFunction, (KnnVectorValues)OffHeapBinarizedVectorValues.load(fi.ordToDocDISIReaderConfiguration, fi.dimension, fi.size, new BinaryQuantizer(fi.dimension, fi.descritizedDimension, fi.similarityFunction), fi.similarityFunction, this.vectorScorer, fi.centroid, fi.centroidDP, fi.vectorDataOffset, fi.vectorDataLength, this.quantizedVectorData), target);
    }

    public RandomVectorScorer getRandomVectorScorer(String field, byte[] target) throws IOException {
        return this.rawVectorsReader.getRandomVectorScorer(field, target);
    }

    public void checkIntegrity() throws IOException {
        this.rawVectorsReader.checkIntegrity();
        CodecUtil.checksumEntireFile((IndexInput)this.quantizedVectorData);
    }

    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        FieldEntry fi = this.fields.get(field);
        if (fi == null) {
            return null;
        }
        if (fi.vectorEncoding != VectorEncoding.FLOAT32) {
            throw new IllegalArgumentException("field=\"" + field + "\" is encoded as: " + String.valueOf(fi.vectorEncoding) + " expected: " + String.valueOf(VectorEncoding.FLOAT32));
        }
        OffHeapBinarizedVectorValues bvv = OffHeapBinarizedVectorValues.load(fi.ordToDocDISIReaderConfiguration, fi.dimension, fi.size, new BinaryQuantizer(fi.dimension, fi.descritizedDimension, fi.similarityFunction), fi.similarityFunction, this.vectorScorer, fi.centroid, fi.centroidDP, fi.vectorDataOffset, fi.vectorDataLength, this.quantizedVectorData);
        return new BinarizedVectorValues(this.rawVectorsReader.getFloatVectorValues(field), bvv);
    }

    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        return this.rawVectorsReader.getByteVectorValues(field);
    }

    public void search(String field, byte[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        this.rawVectorsReader.search(field, target, knnCollector, acceptDocs);
    }

    public void search(String field, float[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        if (knnCollector.k() == 0) {
            return;
        }
        RandomVectorScorer scorer = this.getRandomVectorScorer(field, target);
        if (scorer == null) {
            return;
        }
        OrdinalTranslatedKnnCollector collector = new OrdinalTranslatedKnnCollector(knnCollector, arg_0 -> ((RandomVectorScorer)scorer).ordToDoc(arg_0));
        Bits acceptedOrds = scorer.getAcceptOrds(acceptDocs);
        for (int i = 0; i < scorer.maxOrd(); ++i) {
            if (acceptedOrds != null && !acceptedOrds.get(i)) continue;
            collector.collect(i, scorer.score(i));
            collector.incVisitedCount(1);
        }
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.quantizedVectorData, this.rawVectorsReader});
    }

    public long ramBytesUsed() {
        long size = SHALLOW_SIZE;
        size += RamUsageEstimator.sizeOfMap(this.fields, (long)RamUsageEstimator.shallowSizeOfInstance(FieldEntry.class));
        return size += this.rawVectorsReader.ramBytesUsed();
    }

    @Override
    public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
        Objects.requireNonNull(fieldInfo);
        Map<String, Long> raw = OffHeapByteSizeUtils.getOffHeapByteSize((KnnVectorsReader)this.rawVectorsReader, fieldInfo);
        FieldEntry fieldEntry = this.fields.get(fieldInfo.name);
        if (fieldEntry == null) {
            assert (fieldInfo.getVectorEncoding() == VectorEncoding.BYTE);
            return raw;
        }
        Map<String, Long> quant = Map.of("veb", fieldEntry.vectorDataLength());
        return OffHeapByteSizeUtils.mergeOffHeapByteSizeMaps(raw, quant);
    }

    public float[] getCentroid(String field) {
        FieldEntry fieldEntry = this.fields.get(field);
        if (fieldEntry != null) {
            return fieldEntry.centroid;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexInput openDataInput(SegmentReadState state, int versionMeta, String fileExtension, String codecName, IOContext context) throws IOException {
        IndexInput indexInput;
        block4: {
            String fileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)fileExtension);
            IndexInput in = state.directory.openInput(fileName, context);
            boolean success = false;
            try {
                int versionVectorData = CodecUtil.checkIndexHeader((DataInput)in, (String)codecName, (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                if (versionMeta != versionVectorData) {
                    throw new CorruptIndexException("Format versions mismatch: meta=" + versionMeta + ", " + codecName + "=" + versionVectorData, (DataInput)in);
                }
                CodecUtil.retrieveChecksum((IndexInput)in);
                success = true;
                indexInput = in;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        }
        return indexInput;
    }

    private FieldEntry readField(IndexInput input, FieldInfo info) throws IOException {
        VectorEncoding vectorEncoding = Lucene99HnswVectorsReader.readVectorEncoding((DataInput)input);
        VectorSimilarityFunction similarityFunction = Lucene99HnswVectorsReader.readSimilarityFunction((DataInput)input);
        if (similarityFunction != info.getVectorSimilarityFunction()) {
            throw new IllegalStateException("Inconsistent vector similarity function for field=\"" + info.name + "\"; " + String.valueOf(similarityFunction) + " != " + String.valueOf(info.getVectorSimilarityFunction()));
        }
        return FieldEntry.create(input, vectorEncoding, info.getVectorSimilarityFunction());
    }

    private record FieldEntry(VectorSimilarityFunction similarityFunction, VectorEncoding vectorEncoding, int dimension, int descritizedDimension, long vectorDataOffset, long vectorDataLength, int size, float[] centroid, float centroidDP, OrdToDocDISIReaderConfiguration ordToDocDISIReaderConfiguration) {
        static FieldEntry create(IndexInput input, VectorEncoding vectorEncoding, VectorSimilarityFunction similarityFunction) throws IOException {
            float[] centroid;
            int dimension = input.readVInt();
            long vectorDataOffset = input.readVLong();
            long vectorDataLength = input.readVLong();
            int size = input.readVInt();
            float centroidDP = 0.0f;
            if (size > 0) {
                centroid = new float[dimension];
                input.readFloats(centroid, 0, dimension);
                centroidDP = Float.intBitsToFloat(input.readInt());
            } else {
                centroid = null;
            }
            OrdToDocDISIReaderConfiguration conf = OrdToDocDISIReaderConfiguration.fromStoredMeta((IndexInput)input, (int)size);
            return new FieldEntry(similarityFunction, vectorEncoding, dimension, BQVectorUtils.discretize(dimension, 64), vectorDataOffset, vectorDataLength, size, centroid, centroidDP, conf);
        }
    }

    protected static final class BinarizedVectorValues
    extends FloatVectorValues {
        private final FloatVectorValues rawVectorValues;
        private final BinarizedByteVectorValues quantizedVectorValues;

        BinarizedVectorValues(FloatVectorValues rawVectorValues, BinarizedByteVectorValues quantizedVectorValues) {
            this.rawVectorValues = rawVectorValues;
            this.quantizedVectorValues = quantizedVectorValues;
        }

        public int dimension() {
            return this.rawVectorValues.dimension();
        }

        public int size() {
            return this.rawVectorValues.size();
        }

        public float[] vectorValue(int ord) throws IOException {
            return this.rawVectorValues.vectorValue(ord);
        }

        public BinarizedVectorValues copy() throws IOException {
            return new BinarizedVectorValues(this.rawVectorValues.copy(), this.quantizedVectorValues.copy());
        }

        public Bits getAcceptOrds(Bits acceptDocs) {
            return this.rawVectorValues.getAcceptOrds(acceptDocs);
        }

        public int ordToDoc(int ord) {
            return this.rawVectorValues.ordToDoc(ord);
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return this.rawVectorValues.iterator();
        }

        public VectorScorer scorer(float[] query) throws IOException {
            return this.quantizedVectorValues.scorer(query);
        }

        protected BinarizedByteVectorValues getQuantizedVectorValues() throws IOException {
            return this.quantizedVectorValues;
        }
    }
}

