/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.privilege;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class GetBuiltinPrivilegesResponse
extends ActionResponse {
    private final String[] clusterPrivileges;
    private final String[] indexPrivileges;
    private final String[] remoteClusterPrivileges;

    public GetBuiltinPrivilegesResponse(Collection<String> clusterPrivileges, Collection<String> indexPrivileges) {
        this(clusterPrivileges, indexPrivileges, Collections.emptySet());
    }

    public GetBuiltinPrivilegesResponse(Collection<String> clusterPrivileges, Collection<String> indexPrivileges, Collection<String> remoteClusterPrivileges) {
        this.clusterPrivileges = Objects.requireNonNull(clusterPrivileges, "Cluster privileges cannot be null").toArray(Strings.EMPTY_ARRAY);
        this.indexPrivileges = Objects.requireNonNull(indexPrivileges, "Index privileges cannot be null").toArray(Strings.EMPTY_ARRAY);
        this.remoteClusterPrivileges = Objects.requireNonNull(remoteClusterPrivileges, "Remote cluster privileges cannot be null").toArray(Strings.EMPTY_ARRAY);
    }

    public GetBuiltinPrivilegesResponse() {
        this(Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    public String[] getClusterPrivileges() {
        return this.clusterPrivileges;
    }

    public String[] getIndexPrivileges() {
        return this.indexPrivileges;
    }

    public String[] getRemoteClusterPrivileges() {
        return this.remoteClusterPrivileges;
    }

    public void writeTo(StreamOutput out) throws IOException {
        TransportAction.localOnly();
    }
}

