/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.process;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditMessage;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditor;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.process.StateProcessor;
import org.elasticsearch.xpack.ml.utils.persistence.ResultsPersisterService;

public class IndexingStateProcessor
implements StateProcessor {
    private static final Logger LOGGER = LogManager.getLogger(IndexingStateProcessor.class);
    private static final int READ_BUF_SIZE = 8192;
    private final String jobId;
    private final AbstractAuditor<? extends AbstractAuditMessage> auditor;
    private final ResultsPersisterService resultsPersisterService;

    public IndexingStateProcessor(String jobId, ResultsPersisterService resultsPersisterService, AbstractAuditor<? extends AbstractAuditMessage> auditor) {
        this.jobId = jobId;
        this.resultsPersisterService = resultsPersisterService;
        this.auditor = auditor;
    }

    @Override
    public void process(InputStream in) throws IOException {
        BytesReference bytesToDate = null;
        ArrayList<BytesArray> newBlocks = new ArrayList<BytesArray>();
        byte[] readBuf = new byte[8192];
        int searchFrom = 0;
        int bytesRead = in.read(readBuf);
        while (bytesRead != -1) {
            BytesArray newBlock = new BytesArray(readBuf, 0, bytesRead);
            newBlocks.add(newBlock);
            if (IndexingStateProcessor.findNextZeroByte((BytesReference)newBlock, 0, 0) == -1) {
                searchFrom += bytesRead;
            } else {
                BytesReference newBytes = CompositeBytesReference.of((BytesReference[])newBlocks.toArray(new BytesReference[0]));
                bytesToDate = bytesToDate == null ? newBytes : CompositeBytesReference.of((BytesReference[])new BytesReference[]{bytesToDate, newBytes});
                bytesToDate = this.splitAndPersist(bytesToDate, searchFrom);
                searchFrom = bytesToDate == null ? 0 : bytesToDate.length();
                newBlocks.clear();
            }
            readBuf = new byte[8192];
            bytesRead = in.read(readBuf);
        }
    }

    private BytesReference splitAndPersist(BytesReference bytesRef, int searchFrom) throws IOException {
        int nextZeroByte;
        int splitFrom = 0;
        while ((nextZeroByte = IndexingStateProcessor.findNextZeroByte(bytesRef, searchFrom, splitFrom)) != -1) {
            if (nextZeroByte > splitFrom) {
                this.findAppropriateIndexOrAliasAndPersist(bytesRef.slice(splitFrom, nextZeroByte - splitFrom));
            }
            splitFrom = nextZeroByte + 1;
        }
        if (splitFrom >= bytesRef.length()) {
            return null;
        }
        return bytesRef.slice(splitFrom, bytesRef.length() - splitFrom);
    }

    void findAppropriateIndexOrAliasAndPersist(BytesReference bytes) throws IOException {
        String firstNonBlankLine = IndexingStateProcessor.extractFirstNonBlankLine(bytes);
        if (firstNonBlankLine == null) {
            return;
        }
        String stateDocId = IndexingStateProcessor.extractDocId(firstNonBlankLine);
        String indexOrAlias = this.getConcreteIndexOrWriteAlias(stateDocId);
        this.persist(indexOrAlias, bytes);
    }

    void persist(String indexOrAlias, BytesReference bytes) throws IOException {
        BulkRequest bulkRequest = new BulkRequest().setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).requireAlias(Boolean.valueOf(AnomalyDetectorsIndex.jobStateIndexWriteAlias().equals(indexOrAlias)));
        bulkRequest.add(bytes, indexOrAlias, XContentType.JSON);
        if (bulkRequest.numberOfActions() > 0) {
            LOGGER.trace("[{}] Persisting job state document: index [{}], length [{}]", (Object)this.jobId, (Object)indexOrAlias, (Object)bytes.length());
            try {
                this.resultsPersisterService.bulkIndexWithRetry(bulkRequest, this.jobId, () -> true, retryMessage -> LOGGER.debug("[{}] Bulk indexing of state failed {}", (Object)this.jobId, retryMessage));
            }
            catch (Exception ex) {
                String msg = "failed indexing updated state docs";
                LOGGER.error(() -> Strings.format((String)"[%s] %s", (Object[])new Object[]{this.jobId, msg}), (Throwable)ex);
                this.auditor.error(this.jobId, msg + " error: " + ex.getMessage());
            }
        }
    }

    private static int findNextZeroByte(BytesReference bytesRef, int searchFrom, int splitFrom) {
        return bytesRef.indexOf((byte)0, Math.max(searchFrom, splitFrom));
    }

    static String extractDocId(String firstNonBlankLine) throws IOException {
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, firstNonBlankLine);){
            Map map = parser.map();
            if (!(map.get("index") instanceof Map)) {
                throw new IllegalStateException("Could not extract \"index\" field out of [" + firstNonBlankLine + "]");
            }
            if (!((map = (Map)map.get("index")).get("_id") instanceof String)) {
                throw new IllegalStateException("Could not extract \"index._id\" field out of [" + firstNonBlankLine + "]");
            }
            String string = (String)map.get("_id");
            return string;
        }
    }

    private static String extractFirstNonBlankLine(BytesReference bytesRef) {
        int searchFrom = 0;
        while (searchFrom < bytesRef.length()) {
            int searchTo;
            int newLineMarkerIndex = bytesRef.indexOf((byte)10, searchFrom);
            int n = searchTo = newLineMarkerIndex != -1 ? newLineMarkerIndex : bytesRef.length();
            if (!IndexingStateProcessor.isBlank(bytesRef, searchFrom, searchTo)) {
                return bytesRef.slice(searchFrom, searchTo - searchFrom).utf8ToString();
            }
            searchFrom = newLineMarkerIndex != -1 ? newLineMarkerIndex + 1 : bytesRef.length();
        }
        return null;
    }

    private static boolean isBlank(BytesReference bytesRef, int from, int to) {
        for (int i = from; i < to; ++i) {
            if (bytesRef.get(i) == 32) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getConcreteIndexOrWriteAlias(String documentId) {
        Objects.requireNonNull(documentId);
        SearchRequest searchRequest = new SearchRequest(new String[]{AnomalyDetectorsIndex.jobStateIndexPattern()}).allowPartialSearchResults(false).source(new SearchSourceBuilder().size(1).fetchSource(false).trackTotalHits(false).query((QueryBuilder)new BoolQueryBuilder().filter((QueryBuilder)new IdsQueryBuilder().addIds(new String[]{documentId}))));
        SearchResponse searchResponse = this.resultsPersisterService.searchWithRetry(searchRequest, this.jobId, () -> true, retryMessage -> LOGGER.debug("[{}] {} {}", (Object)this.jobId, (Object)documentId, retryMessage));
        try {
            String string = searchResponse.getHits().getHits().length > 0 ? searchResponse.getHits().getHits()[0].getIndex() : AnomalyDetectorsIndex.jobStateIndexWriteAlias();
            return string;
        }
        finally {
            searchResponse.decRef();
        }
    }
}

