/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.wildcard.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;

abstract class BinaryDvConfirmedQuery
extends Query {
    protected final String field;
    protected final Query approxQuery;

    private BinaryDvConfirmedQuery(Query approximation, String field) {
        this.approxQuery = approximation;
        this.field = field;
    }

    public static Query fromAutomaton(Query approximation, String field, String matchPattern, Automaton automaton) {
        return new BinaryDvConfirmedAutomatonQuery(approximation, field, matchPattern, automaton);
    }

    public static Query fromTerms(Query approximation, String field, BytesRef ... terms) {
        Arrays.sort(terms, BytesRef::compareTo);
        return new BinaryDvConfirmedTermsQuery(approximation, field, terms);
    }

    protected abstract boolean matchesBinaryDV(ByteArrayStreamInput var1, BytesRef var2, BytesRef var3) throws IOException;

    protected abstract Query rewrite(Query var1) throws IOException;

    public Query rewrite(IndexSearcher searcher) throws IOException {
        Query approxRewrite = this.approxQuery.rewrite(searcher);
        if (this.approxQuery != approxRewrite) {
            return this.rewrite(approxRewrite);
        }
        return this;
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final Weight approxWeight = this.approxQuery.createWeight(searcher, scoreMode, boost);
        return new ConstantScoreWeight(this, boost){

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final ScorerSupplier approxScorerSupplier = approxWeight.scorerSupplier(context);
                if (approxScorerSupplier == null) {
                    return null;
                }
                final ByteArrayStreamInput bytes = new ByteArrayStreamInput();
                final BytesRef scratch = new BytesRef();
                final BinaryDocValues values = DocValues.getBinary((LeafReader)context.reader(), (String)BinaryDvConfirmedQuery.this.field);
                return new ScorerSupplier(){

                    public Scorer get(long leadCost) throws IOException {
                        Scorer approxScorer = approxScorerSupplier.get(leadCost);
                        final DocIdSetIterator approxDisi = approxScorer.iterator();
                        TwoPhaseIterator twoPhase = new TwoPhaseIterator(approxDisi){

                            public boolean matches() throws IOException {
                                if (!values.advanceExact(approxDisi.docID())) {
                                    return false;
                                }
                                BytesRef bytesRef = values.binaryValue();
                                bytes.reset(bytesRef.bytes, bytesRef.offset, bytesRef.length);
                                return BinaryDvConfirmedQuery.this.matchesBinaryDV(bytes, bytesRef, scratch);
                            }

                            public float matchCost() {
                                return 1000.0f;
                            }
                        };
                        return new ConstantScoreScorer(this.score(), scoreMode, twoPhase);
                    }

                    public long cost() {
                        return approxScorerSupplier.cost();
                    }
                };
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        BinaryDvConfirmedQuery other = (BinaryDvConfirmedQuery)((Object)obj);
        return Objects.equals(this.field, other.field) && Objects.equals(this.approxQuery, other.approxQuery);
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.field, this.approxQuery);
    }

    Query getApproximationQuery() {
        return this.approxQuery;
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf((Query)this);
        }
    }

    private static class BinaryDvConfirmedAutomatonQuery
    extends BinaryDvConfirmedQuery {
        private final ByteRunAutomaton byteRunAutomaton;
        private final String matchPattern;

        private BinaryDvConfirmedAutomatonQuery(Query approximation, String field, String matchPattern, Automaton automaton) {
            this(approximation, field, matchPattern, new ByteRunAutomaton(automaton));
        }

        private BinaryDvConfirmedAutomatonQuery(Query approximation, String field, String matchPattern, ByteRunAutomaton byteRunAutomaton) {
            super(approximation, field);
            this.matchPattern = matchPattern;
            this.byteRunAutomaton = byteRunAutomaton;
        }

        @Override
        protected boolean matchesBinaryDV(ByteArrayStreamInput bytes, BytesRef bytesRef, BytesRef scratch) throws IOException {
            int size = bytes.readVInt();
            for (int i = 0; i < size; ++i) {
                int valLength = bytes.readVInt();
                if (this.byteRunAutomaton.run(bytesRef.bytes, bytes.getPosition(), valLength)) {
                    return true;
                }
                bytes.skipBytes((long)valLength);
            }
            return false;
        }

        @Override
        protected Query rewrite(Query approxRewrite) {
            return new BinaryDvConfirmedAutomatonQuery(approxRewrite, this.field, this.matchPattern, this.byteRunAutomaton);
        }

        public String toString(String field) {
            return field + ":" + this.matchPattern;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BinaryDvConfirmedAutomatonQuery other = (BinaryDvConfirmedAutomatonQuery)((Object)o);
            return Objects.equals(this.byteRunAutomaton, other.byteRunAutomaton) && Objects.equals(this.matchPattern, other.matchPattern);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.matchPattern, this.byteRunAutomaton);
        }
    }

    private static class BinaryDvConfirmedTermsQuery
    extends BinaryDvConfirmedQuery {
        private final BytesRef[] terms;

        private BinaryDvConfirmedTermsQuery(Query approximation, String field, BytesRef[] terms) {
            super(approximation, field);
            this.terms = terms;
        }

        @Override
        protected boolean matchesBinaryDV(ByteArrayStreamInput bytes, BytesRef bytesRef, BytesRef scratch) throws IOException {
            scratch.bytes = bytesRef.bytes;
            int size = bytes.readVInt();
            for (int i = 0; i < size; ++i) {
                int valLength = bytes.readVInt();
                scratch.offset = bytes.getPosition();
                scratch.length = valLength;
                if (this.terms.length == 1) {
                    if (this.terms[0].bytesEquals(scratch)) {
                        return true;
                    }
                } else {
                    int pos = Arrays.binarySearch(this.terms, scratch, BytesRef::compareTo);
                    if (pos >= 0) {
                        assert (this.terms[pos].bytesEquals(scratch)) : "Expected term at position " + pos + " to match scratch, but it did not.";
                        return true;
                    }
                }
                bytes.skipBytes((long)valLength);
            }
            assert (bytes.available() == 0) : "Expected no bytes left to read, but found " + bytes.available();
            return false;
        }

        @Override
        protected Query rewrite(Query approxRewrite) {
            return new BinaryDvConfirmedTermsQuery(approxRewrite, this.field, this.terms);
        }

        public String toString(String field) {
            StringBuilder builder = new StringBuilder(field + ": [");
            for (int i = 0; i < this.terms.length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.terms[i].utf8ToString());
            }
            builder.append("]");
            return builder.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BinaryDvConfirmedTermsQuery that = (BinaryDvConfirmedTermsQuery)((Object)o);
            return Arrays.equals(this.terms, that.terms);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), Arrays.hashCode(this.terms));
        }
    }
}

