/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http;

import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.logging.ThrottlerManager;

public class HttpUtils {
    public static void checkForFailureStatusCode(ThrottlerManager throttlerManager, Logger logger, Request request, HttpResult result) {
        if (result.response().getStatusLine().getStatusCode() >= 300) {
            String message = HttpUtils.getStatusCodeErrorMessage(request, result);
            throttlerManager.warn(logger, message);
            throw new IllegalStateException(message);
        }
    }

    private static String getStatusCodeErrorMessage(Request request, HttpResult result) {
        int statusCode = result.response().getStatusLine().getStatusCode();
        if (statusCode >= 400) {
            return Strings.format((String)"Received a failure status code for request from inference entity id [%s] status [%s]", (Object[])new Object[]{request.getInferenceEntityId(), result.response().getStatusLine().getStatusCode()});
        }
        if (statusCode >= 300) {
            return Strings.format((String)"Unhandled redirection for request from inference entity id [%s] status [%s]", (Object[])new Object[]{request.getInferenceEntityId(), result.response().getStatusLine().getStatusCode()});
        }
        return "";
    }

    public static void checkForEmptyBody(ThrottlerManager throttlerManager, Logger logger, Request request, HttpResult result) {
        if (result.isBodyEmpty() && !request.isStreaming()) {
            String message = Strings.format((String)"Response body was empty for request from inference entity id [%s]", (Object[])new Object[]{request.getInferenceEntityId()});
            throttlerManager.warn(logger, message);
            throw new IllegalStateException(message);
        }
    }

    private HttpUtils() {
    }
}

