/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.rate;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.analytics.rate.Rate;

public class InternalRate
extends InternalNumericMetricsAggregation.SingleValue
implements Rate {
    final double sum;
    final double divisor;

    public InternalRate(String name, double sum, double divisor, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, formatter, metadata);
        this.sum = sum;
        this.divisor = divisor;
    }

    public InternalRate(StreamInput in) throws IOException {
        super(in);
        this.sum = in.readDouble();
        this.divisor = in.readDouble();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.format);
        out.writeDouble(this.sum);
        out.writeDouble(this.divisor);
    }

    public String getWriteableName() {
        return "rate";
    }

    public double value() {
        return this.sum / this.divisor;
    }

    @Override
    public double getValue() {
        return this.sum / this.divisor;
    }

    DocValueFormat format() {
        return this.format;
    }

    protected AggregatorReducer getLeaderReducer(AggregationReduceContext reduceContext, int size) {
        return new AggregatorReducer(){
            final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
            Double firstDivisor = null;

            public void accept(InternalAggregation aggregation) {
                double value = ((InternalRate)aggregation).sum;
                this.kahanSummation.add(value);
                if (this.firstDivisor == null) {
                    this.firstDivisor = ((InternalRate)aggregation).divisor;
                }
            }

            public InternalAggregation get() {
                return new InternalRate(InternalRate.this.name, this.kahanSummation.value(), this.firstDivisor, InternalRate.this.format, InternalRate.this.getMetadata());
            }
        };
    }

    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return new InternalRate(this.name, samplingContext.scaleUp(this.sum), this.divisor, this.format, this.getMetadata());
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.value());
        if (this.format != DocValueFormat.RAW) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(this.value()).toString());
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sum, this.divisor);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalRate that = (InternalRate)obj;
        return Objects.equals(this.sum, that.sum) && Objects.equals(this.divisor, that.divisor);
    }
}

