/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.tasks;

import com.microsoft.graph.core.exceptions.ClientException;
import com.microsoft.graph.core.models.IProgressCallback;
import com.microsoft.graph.core.models.IUploadSession;
import com.microsoft.graph.core.models.UploadResult;
import com.microsoft.graph.core.models.UploadSession;
import com.microsoft.graph.core.requests.BaseGraphRequestAdapter;
import com.microsoft.graph.core.requests.GraphClientFactory;
import com.microsoft.graph.core.requests.options.GraphClientOption;
import com.microsoft.graph.core.requests.upload.UploadSessionRequestBuilder;
import com.microsoft.graph.core.requests.upload.UploadSliceRequestBuilder;
import com.microsoft.kiota.ApiException;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.authentication.AnonymousAuthenticationProvider;
import com.microsoft.kiota.authentication.AuthenticationProvider;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.time.OffsetDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class LargeFileUploadTask<T extends Parsable> {
    private static final long DEFAULT_MAX_SLICE_SIZE = 0x500000L;
    private IUploadSession uploadSession;
    private final RequestAdapter requestAdapter;
    private final InputStream uploadStream;
    private final long maxSliceSize;
    private ArrayList<AbstractMap.SimpleEntry<Long, Long>> rangesRemaining;
    private final long totalUploadLength;
    private final ParsableFactory<T> factory;
    private long amountUploaded;

    public LargeFileUploadTask(@Nullable RequestAdapter requestAdapter, @Nonnull Parsable uploadSession, @Nonnull InputStream uploadStream, long streamSize, @Nonnull ParsableFactory<T> factory) throws IllegalAccessException, IOException, InvocationTargetException, NoSuchMethodException {
        this(requestAdapter, uploadSession, uploadStream, streamSize, 0x500000L, factory);
    }

    public LargeFileUploadTask(@Nullable RequestAdapter requestAdapter, @Nonnull Parsable uploadSession, @Nonnull InputStream uploadStream, long streamSize, long maxSliceSize, @Nonnull ParsableFactory<T> factory) throws IllegalAccessException, IOException, InvocationTargetException, NoSuchMethodException {
        Objects.requireNonNull(uploadSession);
        Objects.requireNonNull(uploadStream);
        Objects.requireNonNull(factory);
        this.uploadSession = this.extractSessionFromParsable(uploadSession);
        this.requestAdapter = Objects.isNull(requestAdapter) ? this.initializeAdapter(this.uploadSession.getUploadUrl()) : requestAdapter;
        this.totalUploadLength = streamSize;
        this.rangesRemaining = this.getRangesRemaining(this.uploadSession);
        this.uploadStream = uploadStream;
        this.maxSliceSize = maxSliceSize;
        this.factory = factory;
    }

    @Nonnull
    public UploadResult<T> upload() throws IOException, InterruptedException {
        return this.upload(3, null);
    }

    @Nonnull
    public UploadResult<T> upload(int maxTries, @Nullable IProgressCallback progress) throws IOException, InterruptedException {
        int uploadTries = 0;
        ArrayList<Throwable> exceptionsList = new ArrayList<Throwable>();
        while (uploadTries < maxTries) {
            List<UploadSliceRequestBuilder<T>> uploadSliceRequestBuilders = this.getUploadSliceRequests();
            for (UploadSliceRequestBuilder<T> request : uploadSliceRequestBuilders) {
                UploadResult<T> result = this.uploadSlice(request, exceptionsList);
                this.amountUploaded += request.getRangeLength();
                if (progress != null) {
                    progress.report(this.amountUploaded, this.totalUploadLength);
                }
                if (!result.isUploadSuccessful()) continue;
                return result;
            }
            this.updateSessionStatus();
            if (++uploadTries >= maxTries) continue;
            TimeUnit.SECONDS.sleep(2L * (long)uploadTries * (long)uploadTries);
        }
        throw new CancellationException("The upload task was retried the maximum number of times without success and has been cancelled.");
    }

    @Nonnull
    public UploadResult<T> resume() throws ClientException, IOException, InterruptedException {
        return this.resume(3, null);
    }

    @Nonnull
    public UploadResult<T> resume(int maxTries, @Nullable IProgressCallback progress) throws ClientException, IOException, InterruptedException {
        OffsetDateTime expirationDateTime;
        IUploadSession session = this.updateSessionStatus();
        OffsetDateTime offsetDateTime = expirationDateTime = Objects.isNull(session.getExpirationDateTime()) ? OffsetDateTime.now() : session.getExpirationDateTime();
        if (expirationDateTime.isBefore(OffsetDateTime.now()) || expirationDateTime.isEqual(OffsetDateTime.now())) {
            throw new ClientException("Upload session expired. Upload cannot resume");
        }
        return this.upload(maxTries, progress);
    }

    public void deleteSession() throws ClientException {
        OffsetDateTime expirationDateTime;
        OffsetDateTime offsetDateTime = expirationDateTime = Objects.isNull(this.uploadSession.getExpirationDateTime()) ? OffsetDateTime.now() : this.uploadSession.getExpirationDateTime();
        if (expirationDateTime.isBefore(OffsetDateTime.now()) || expirationDateTime.isEqual(OffsetDateTime.now())) {
            throw new ClientException("Upload session expired. Upload cannot resume");
        }
        UploadSessionRequestBuilder<T> builder = new UploadSessionRequestBuilder<T>(this.uploadSession.getUploadUrl(), this.requestAdapter, this.factory);
        builder.delete();
    }

    @Nonnull
    public IUploadSession updateSessionStatus() {
        UploadSessionRequestBuilder<T> sessionRequestBuilder = new UploadSessionRequestBuilder<T>(this.uploadSession.getUploadUrl(), this.requestAdapter, this.factory);
        IUploadSession session = sessionRequestBuilder.get();
        this.rangesRemaining = this.getRangesRemaining(session);
        session.setUploadUrl(this.uploadSession.getUploadUrl());
        this.uploadSession = session;
        return session;
    }

    private UploadResult<T> uploadSlice(UploadSliceRequestBuilder<T> uploadSliceRequestBuilder, ArrayList<Throwable> exceptionsList) throws IOException {
        byte[] buffer = this.chunkInputStream(this.uploadStream, (int)uploadSliceRequestBuilder.getRangeLength());
        ByteArrayInputStream chunkStream = new ByteArrayInputStream(buffer);
        try {
            return uploadSliceRequestBuilder.put(chunkStream);
        }
        catch (ApiException apiException) {
            return this.handleApiException(apiException, exceptionsList);
        }
    }

    private UploadResult<T> handleApiException(ApiException apiException, ArrayList<Throwable> exceptionsList) {
        if (apiException.getMessage().toLowerCase(Locale.ROOT).contains("generalException".toLowerCase(Locale.ROOT)) || apiException.getMessage().toLowerCase(Locale.ROOT).contains("timeout".toLowerCase(Locale.ROOT))) {
            exceptionsList.add(apiException);
        } else if (apiException.getMessage().toLowerCase(Locale.ROOT).contains("invalidRange".toLowerCase(Locale.ROOT))) {
            return new UploadResult();
        }
        throw apiException;
    }

    @Nonnull
    protected List<UploadSliceRequestBuilder<T>> getUploadSliceRequests() {
        ArrayList<UploadSliceRequestBuilder<T>> builders = new ArrayList<UploadSliceRequestBuilder<T>>();
        for (Map.Entry entry : this.rangesRemaining) {
            long nextSliceSize;
            long currentEnd = (Long)entry.getValue();
            for (long currentRangeBegin = ((Long)entry.getKey()).longValue(); currentRangeBegin < currentEnd; currentRangeBegin += nextSliceSize) {
                nextSliceSize = this.nextSliceSize(currentRangeBegin, currentEnd);
                UploadSliceRequestBuilder<T> sliceRequestBuilder = new UploadSliceRequestBuilder<T>(this.uploadSession.getUploadUrl(), this.requestAdapter, currentRangeBegin, currentRangeBegin + nextSliceSize - 1L, this.totalUploadLength, this.factory);
                builders.add(sliceRequestBuilder);
            }
        }
        return builders;
    }

    private ArrayList<AbstractMap.SimpleEntry<Long, Long>> getRangesRemaining(IUploadSession uploadSession) {
        ArrayList<AbstractMap.SimpleEntry<Long, Long>> remaining = new ArrayList<AbstractMap.SimpleEntry<Long, Long>>();
        for (String range : uploadSession.getNextExpectedRanges()) {
            String[] specifiers = range.split("-");
            remaining.add(new AbstractMap.SimpleEntry<Long, Long>(Long.valueOf(specifiers[0]), specifiers.length == 2 ? Long.parseLong(specifiers[1]) : this.totalUploadLength - 1L));
        }
        return remaining;
    }

    private RequestAdapter initializeAdapter(String uploadUrl) {
        GraphClientOption options = new GraphClientOption();
        options.featureTracker.setFeatureUsage(2048);
        OkHttpClient client = GraphClientFactory.create(options).build();
        return new BaseGraphRequestAdapter((AuthenticationProvider)new AnonymousAuthenticationProvider(), uploadUrl, client);
    }

    @Nonnull
    private IUploadSession extractSessionFromParsable(@Nonnull Parsable uploadSession) throws IllegalArgumentException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Map deserializers = uploadSession.getFieldDeserializers();
        if (!deserializers.containsKey("expirationDateTime")) {
            throw new IllegalArgumentException("The Parsable does not contain the 'expirationDateTime' property");
        }
        if (!deserializers.containsKey("nextExpectedRanges")) {
            throw new IllegalArgumentException("The Parsable does not contain the 'nextExpectedRanges' property");
        }
        if (!deserializers.containsKey("uploadUrl")) {
            throw new IllegalArgumentException("The Parsable does not contain the 'uploadUrl' property");
        }
        UploadSession session = new UploadSession();
        session.setExpirationDateTime((OffsetDateTime)uploadSession.getClass().getDeclaredMethod("getExpirationDateTime", new Class[0]).invoke((Object)uploadSession, new Object[0]));
        session.setUploadUrl((String)uploadSession.getClass().getDeclaredMethod("getUploadUrl", new Class[0]).invoke((Object)uploadSession, new Object[0]));
        session.setNextExpectedRanges((List)uploadSession.getClass().getDeclaredMethod("getNextExpectedRanges", new Class[0]).invoke((Object)uploadSession, new Object[0]));
        return session;
    }

    private long nextSliceSize(long rangeBegin, long rangeEnd) {
        long size = rangeEnd - rangeBegin + 1L;
        return Math.min(size, this.maxSliceSize);
    }

    private byte[] chunkInputStream(InputStream stream, int length) throws IOException {
        byte[] buffer = new byte[length];
        int lengthAssert = stream.read(buffer);
        assert (lengthAssert == length);
        return buffer;
    }
}

