/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.shaded.com.maxmind.geoip2.exception;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public final class HttpException
extends IOException {
    private static final long serialVersionUID = -8301101841509056974L;
    private final int httpStatus;
    private final URI uri;

    public HttpException(String message, int httpStatus, URI uri) {
        super(message);
        this.httpStatus = httpStatus;
        this.uri = uri;
    }

    public HttpException(String message, int httpStatus, URI uri, Throwable cause) {
        super(message, cause);
        this.httpStatus = httpStatus;
        this.uri = uri;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public URI getUri() {
        return this.uri;
    }

    @Deprecated
    public URL getUrl() {
        try {
            return this.uri.toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

