/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb.es819;

import java.io.IOException;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.elasticsearch.index.codec.tsdb.es819.DocValuesConsumerUtil;

class TsdbDocValuesProducer
extends EmptyDocValuesProducer {
    final DocValuesConsumerUtil.MergeStats mergeStats;
    final DocValuesProducer actual;

    TsdbDocValuesProducer(DocValuesConsumerUtil.MergeStats mergeStats) {
        this.mergeStats = mergeStats;
        this.actual = null;
    }

    TsdbDocValuesProducer(DocValuesProducer valuesProducer) {
        if (valuesProducer instanceof TsdbDocValuesProducer) {
            TsdbDocValuesProducer tsdb = (TsdbDocValuesProducer)valuesProducer;
            this.mergeStats = tsdb.mergeStats;
        } else {
            this.mergeStats = DocValuesConsumerUtil.UNSUPPORTED;
        }
        this.actual = valuesProducer;
    }

    @Override
    public SortedDocValues getSorted(FieldInfo field) throws IOException {
        if (this.actual != null) {
            return this.actual.getSorted(field);
        }
        return super.getSorted(field);
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        if (this.actual != null) {
            return this.actual.getSortedSet(field);
        }
        return super.getSortedSet(field);
    }

    @Override
    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        if (this.actual != null) {
            return this.actual.getSortedNumeric(field);
        }
        return super.getSortedNumeric(field);
    }
}

