/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.geo.GeoLineDecomposer;
import org.elasticsearch.common.geo.GeoPolygonDecomposer;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;

public final class GeometryNormalizer {
    private GeometryNormalizer() {
    }

    public static Geometry apply(final Orientation orientation, Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        return geometry.visit(new GeometryVisitor<Geometry, RuntimeException>(){

            @Override
            public Geometry visit(Circle circle) {
                if (circle.isEmpty()) {
                    return GeometryCollection.EMPTY;
                }
                double[] latlon = new double[]{circle.getX(), circle.getY()};
                GeoUtils.normalizePoint(latlon);
                return new Circle(latlon[0], latlon[1], circle.getRadiusMeters());
            }

            @Override
            public Geometry visit(GeometryCollection<?> collection) {
                ArrayList<Geometry> shapes = new ArrayList<Geometry>(collection.size());
                for (Geometry shape : collection) {
                    Geometry geometry = shape.visit(this);
                    if (geometry.isEmpty()) continue;
                    shapes.add(geometry);
                }
                if (collection.isEmpty()) {
                    return GeometryCollection.EMPTY;
                }
                if (shapes.size() == 1) {
                    return (Geometry)shapes.get(0);
                }
                return new GeometryCollection(shapes);
            }

            @Override
            public Geometry visit(Line line) {
                ArrayList<Line> lines = new ArrayList<Line>();
                GeoLineDecomposer.decomposeLine(line, lines);
                if (lines.isEmpty()) {
                    return Line.EMPTY;
                }
                if (lines.size() == 1) {
                    return (Geometry)lines.get(0);
                }
                return new MultiLine((List<Line>)lines);
            }

            @Override
            public Geometry visit(LinearRing ring) {
                throw new IllegalArgumentException("invalid shape type found [LinearRing]");
            }

            @Override
            public Geometry visit(MultiLine multiLine) {
                ArrayList<Line> lines = new ArrayList<Line>();
                GeoLineDecomposer.decomposeMultiLine(multiLine, lines);
                if (lines.isEmpty()) {
                    return MultiLine.EMPTY;
                }
                if (lines.size() == 1) {
                    return (Geometry)lines.get(0);
                }
                return new MultiLine((List<Line>)lines);
            }

            @Override
            public Geometry visit(MultiPoint multiPoint) {
                if (multiPoint.isEmpty()) {
                    return MultiPoint.EMPTY;
                }
                if (multiPoint.size() == 1) {
                    return ((Point)multiPoint.get(0)).visit(this);
                }
                ArrayList<Point> points = new ArrayList<Point>();
                for (Point point : multiPoint) {
                    points.add((Point)point.visit(this));
                }
                return new MultiPoint((List<Point>)points);
            }

            @Override
            public Geometry visit(MultiPolygon multiPolygon) {
                ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                GeoPolygonDecomposer.decomposeMultiPolygon(multiPolygon, orientation.getAsBoolean(), polygons);
                if (polygons.isEmpty()) {
                    return MultiPolygon.EMPTY;
                }
                if (polygons.size() == 1) {
                    return (Geometry)polygons.get(0);
                }
                return new MultiPolygon((List<Polygon>)polygons);
            }

            @Override
            public Geometry visit(Point point) {
                double[] latlon = new double[]{point.getX(), point.getY()};
                GeoUtils.normalizePoint(latlon);
                return new Point(latlon[0], latlon[1]);
            }

            @Override
            public Geometry visit(Polygon polygon) {
                ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                GeoPolygonDecomposer.decomposePolygon(polygon, orientation.getAsBoolean(), polygons);
                if (polygons.isEmpty()) {
                    return Polygon.EMPTY;
                }
                if (polygons.size() == 1) {
                    return (Geometry)polygons.get(0);
                }
                return new MultiPolygon((List<Polygon>)polygons);
            }

            @Override
            public Geometry visit(Rectangle rectangle) {
                return rectangle;
            }
        });
    }

    public static boolean needsNormalize(Orientation orientation, Geometry geometry) {
        if (geometry == null) {
            return false;
        }
        return geometry.visit(new GeometryVisitor<Boolean, RuntimeException>(){

            @Override
            public Boolean visit(Circle circle) {
                if (circle.isEmpty()) {
                    return Boolean.FALSE;
                }
                return GeoUtils.needsNormalizeLat(circle.getLat()) || GeoUtils.needsNormalizeLon(circle.getLon());
            }

            @Override
            public Boolean visit(GeometryCollection<?> collection) {
                for (Geometry shape : collection) {
                    if (!shape.visit(this).booleanValue()) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            public Boolean visit(Line line) {
                return GeoLineDecomposer.needsDecomposing(line);
            }

            @Override
            public Boolean visit(LinearRing ring) {
                throw new IllegalArgumentException("invalid shape type found [LinearRing]");
            }

            @Override
            public Boolean visit(MultiLine multiLine) {
                for (Line line : multiLine) {
                    if (!this.visit(line).booleanValue()) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            public Boolean visit(MultiPoint multiPoint) {
                for (Point point : multiPoint) {
                    if (!this.visit(point).booleanValue()) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            public Boolean visit(MultiPolygon multiPolygon) {
                for (Polygon polygon : multiPolygon) {
                    if (!this.visit(polygon).booleanValue()) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            public Boolean visit(Point point) {
                return GeoUtils.needsNormalizeLat(point.getLat()) || GeoUtils.needsNormalizeLon(point.getLon());
            }

            @Override
            public Boolean visit(Polygon polygon) {
                return GeoPolygonDecomposer.needsDecomposing(polygon);
            }

            @Override
            public Boolean visit(Rectangle rectangle) {
                return Boolean.FALSE;
            }
        });
    }
}

