/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancingRoundSummary;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalance;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceMetrics;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

public class AllocationBalancingRoundSummaryService {
    public static final Setting<Boolean> ENABLE_BALANCER_ROUND_SUMMARIES_SETTING = Setting.boolSetting("cluster.routing.allocation.desired_balance.enable_balancer_round_summaries", false, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> BALANCER_ROUND_SUMMARIES_LOG_INTERVAL_SETTING = Setting.timeSetting("cluster.routing.allocation.desired_balance.balanace_round_summaries_interval", TimeValue.timeValueSeconds(10L), TimeValue.ZERO, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private static final Logger logger = LogManager.getLogger(AllocationBalancingRoundSummaryService.class);
    private final ThreadPool threadPool;
    private volatile boolean enableBalancerRoundSummaries;
    private volatile TimeValue summaryReportInterval;
    private final ConcurrentLinkedQueue<BalancingRoundSummary> summaries = new ConcurrentLinkedQueue();
    private final AtomicReference<Scheduler.Cancellable> scheduledReportFuture = new AtomicReference();

    public AllocationBalancingRoundSummaryService(ThreadPool threadPool, ClusterSettings clusterSettings) {
        this.threadPool = threadPool;
        this.enableBalancerRoundSummaries = clusterSettings.get(ENABLE_BALANCER_ROUND_SUMMARIES_SETTING);
        this.summaryReportInterval = clusterSettings.get(BALANCER_ROUND_SUMMARIES_LOG_INTERVAL_SETTING);
        clusterSettings.initializeAndWatch(ENABLE_BALANCER_ROUND_SUMMARIES_SETTING, value -> {
            this.enableBalancerRoundSummaries = value;
            this.updateBalancingRoundSummaryReporting();
        });
        clusterSettings.initializeAndWatch(BALANCER_ROUND_SUMMARIES_LOG_INTERVAL_SETTING, value -> {
            this.summaryReportInterval = value;
        });
    }

    public static BalancingRoundSummary createBalancerRoundSummary(DesiredBalance oldDesiredBalance, DesiredBalance newDesiredBalance) {
        return new BalancingRoundSummary(AllocationBalancingRoundSummaryService.createWeightsSummary(oldDesiredBalance, newDesiredBalance), DesiredBalance.shardMovements(oldDesiredBalance, newDesiredBalance));
    }

    private static Map<String, BalancingRoundSummary.NodesWeightsChanges> createWeightsSummary(DesiredBalance oldDesiredBalance, DesiredBalance newDesiredBalance) {
        DiscoveryNode discoveryNode;
        Map<DiscoveryNode, DesiredBalanceMetrics.NodeWeightStats> oldWeightsPerNode = oldDesiredBalance.weightsPerNode();
        Map<DiscoveryNode, DesiredBalanceMetrics.NodeWeightStats> newWeightsPerNode = newDesiredBalance.weightsPerNode();
        HashMap<String, BalancingRoundSummary.NodesWeightsChanges> nodeNameToWeightInfo = new HashMap<String, BalancingRoundSummary.NodesWeightsChanges>(oldWeightsPerNode.size());
        for (Map.Entry<DiscoveryNode, DesiredBalanceMetrics.NodeWeightStats> nodeAndWeights : oldWeightsPerNode.entrySet()) {
            discoveryNode = nodeAndWeights.getKey();
            DesiredBalanceMetrics.NodeWeightStats oldNodeWeightStats = nodeAndWeights.getValue();
            DesiredBalanceMetrics.NodeWeightStats newNodeWeightStats = newWeightsPerNode.getOrDefault(discoveryNode, DesiredBalanceMetrics.NodeWeightStats.ZERO);
            nodeNameToWeightInfo.put(discoveryNode.getName(), new BalancingRoundSummary.NodesWeightsChanges(oldNodeWeightStats, BalancingRoundSummary.NodeWeightsDiff.create(oldNodeWeightStats, newNodeWeightStats)));
        }
        for (Map.Entry<DiscoveryNode, DesiredBalanceMetrics.NodeWeightStats> nodeAndWeights : newWeightsPerNode.entrySet()) {
            discoveryNode = nodeAndWeights.getKey();
            if (nodeNameToWeightInfo.containsKey(discoveryNode.getName())) continue;
            nodeNameToWeightInfo.put(discoveryNode.getName(), new BalancingRoundSummary.NodesWeightsChanges(DesiredBalanceMetrics.NodeWeightStats.ZERO, BalancingRoundSummary.NodeWeightsDiff.create(DesiredBalanceMetrics.NodeWeightStats.ZERO, nodeAndWeights.getValue())));
        }
        return nodeNameToWeightInfo;
    }

    public void addBalancerRoundSummary(DesiredBalance oldDesiredBalance, DesiredBalance newDesiredBalance) {
        this.addBalancerRoundSummary(AllocationBalancingRoundSummaryService.createBalancerRoundSummary(oldDesiredBalance, newDesiredBalance));
    }

    public void addBalancerRoundSummary(BalancingRoundSummary summary) {
        if (!this.enableBalancerRoundSummaries) {
            return;
        }
        this.summaries.add(summary);
    }

    private void reportSummariesAndThenReschedule() {
        this.drainAndReportSummaries();
        this.rescheduleReporting();
    }

    private void drainAndReportSummaries() {
        BalancingRoundSummary.CombinedBalancingRoundSummary combinedSummaries = this.drainSummaries();
        if (combinedSummaries == BalancingRoundSummary.CombinedBalancingRoundSummary.EMPTY_RESULTS) {
            return;
        }
        logger.info("Balancing round summaries: " + String.valueOf(combinedSummaries));
    }

    private BalancingRoundSummary.CombinedBalancingRoundSummary drainSummaries() {
        ArrayList<BalancingRoundSummary> batchOfSummaries = new ArrayList<BalancingRoundSummary>();
        while (!this.summaries.isEmpty()) {
            batchOfSummaries.add(this.summaries.poll());
        }
        return BalancingRoundSummary.CombinedBalancingRoundSummary.combine(batchOfSummaries);
    }

    private void updateBalancingRoundSummaryReporting() {
        if (this.enableBalancerRoundSummaries) {
            this.startReporting(this.summaryReportInterval);
        } else {
            this.cancelReporting();
            this.drainSummaries();
        }
    }

    private void startReporting(TimeValue intervalValue) {
        if (this.scheduledReportFuture.get() == null) {
            this.scheduleReporting(intervalValue);
        }
    }

    private void cancelReporting() {
        Scheduler.Cancellable future = this.scheduledReportFuture.getAndSet(null);
        if (future != null) {
            future.cancel();
        }
    }

    private void scheduleReporting(TimeValue intervalValue) {
        this.scheduledReportFuture.set(this.threadPool.schedule(this::reportSummariesAndThenReschedule, intervalValue, this.threadPool.executor("generic")));
    }

    private void rescheduleReporting() {
        if (this.enableBalancerRoundSummaries) {
            this.scheduleReporting(this.summaryReportInterval);
        } else {
            this.cancelReporting();
        }
    }

    protected void verifyNumberOfSummaries(int numberOfSummaries) {
        assert (numberOfSummaries == this.summaries.size());
    }
}

