"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DescriptiveSwitch = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DescriptiveSwitch = ({
  label,
  checked,
  tooltipText,
  onToggle,
  testSubject
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    css: {
      flexGrow: 'unset'
    },
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": testSubject,
    compressed: true,
    label: label,
    checked: checked,
    onChange: onToggle,
    showLabel: false
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, label), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: tooltipText,
    position: "bottom",
    type: "question",
    size: "s"
  })));
};
exports.DescriptiveSwitch = DescriptiveSwitch;