"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SemanticTextInfo = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _fileUploadCommon = require("@kbn/file-upload-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SemanticTextInfo = ({
  results
}) => {
  return results.format === _fileUploadCommon.FILE_FORMATS.TIKA ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.semanticTextInfo.title",
      defaultMessage: "Semantic text field type now available"
    }),
    color: "primary",
    iconType: "info"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.semanticTextInfo.body",
    defaultMessage: "You can add a {semanticText} field when importing this file to easily enable semantic search on the content.",
    values: {
      semanticText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/guide/en/elasticsearch/reference/current/semantic-text.html",
        target: "_blank",
        external: true
      }, /*#__PURE__*/_react.default.createElement("code", {
        css: {
          fontWeight: 'bold'
        }
      }, "semantic_text"))
    }
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.semanticTextInfo.body2",
    defaultMessage: "In the Advanced tab, click 'Add additional field' and choose 'Add semantic text field'."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null;
};
exports.SemanticTextInfo = SemanticTextInfo;