"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditFlyout = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _overrides = require("./overrides");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EditFlyout extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "applyAndClose", () => {
      this.applyOverrides();
      this.props.closeEditFlyout();
    });
    (0, _defineProperty2.default)(this, "setApplyOverrides", applyOverrides => {
      this.applyOverrides = applyOverrides;
    });
    (0, _defineProperty2.default)(this, "unsetApplyOverrides", () => {
      this.applyOverrides = () => {};
    });
    (0, _defineProperty2.default)(this, "setOverridesValid", overridesValid => {
      this.setState({
        overridesValid
      });
    });
    this.applyOverrides = () => {};
    this.state = {
      overridesValid: true
    };
  }
  render() {
    const {
      isFlyoutVisible,
      closeEditFlyout,
      setOverrides,
      overrides,
      originalSettings,
      fields
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isFlyoutVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout
    // ownFocus
    , {
      onClose: closeEditFlyout,
      size: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.editFlyout.overrideSettingsTitle",
      defaultMessage: "Override settings"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_overrides.Overrides, {
      setOverrides: setOverrides,
      overrides: overrides,
      originalSettings: originalSettings,
      setApplyOverrides: this.setApplyOverrides,
      setOverridesValid: this.setOverridesValid,
      fields: fields
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "cross",
      onClick: closeEditFlyout,
      flush: "left"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.editFlyout.closeOverrideSettingsButtonLabel",
      defaultMessage: "Close"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: this.applyAndClose,
      isDisabled: this.state.overridesValid === false,
      fill: true
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.editFlyout.applyOverrideSettingsButtonLabel",
      defaultMessage: "Apply"
    })))))));
  }
}
exports.EditFlyout = EditFlyout;