"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertDatatableColumnToDataViewFieldSpec = convertDatatableColumnToDataViewFieldSpec;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Convert a datatable column to a DataViewFieldSpec
 */
function convertDatatableColumnToDataViewFieldSpec(column) {
  var _column$meta, _esType, _column$meta$type, _column$meta2;
  let esType = (_column$meta = column.meta) === null || _column$meta === void 0 ? void 0 : _column$meta.esType;
  let timeSeriesMetric;

  // 'counter_integer', 'counter_long', 'counter_double'...
  if ((_esType = esType) !== null && _esType !== void 0 && _esType.startsWith('counter_')) {
    var _esType2;
    esType = (_esType2 = esType) === null || _esType2 === void 0 ? void 0 : _esType2.replace('counter_', '');
    timeSeriesMetric = 'counter';
  }

  // `DataViewField` class is defined in "data-views" plugin, so we can't create an instance of it from a package.
  // We will return a data view field spec here instead then.
  return {
    name: column.name,
    type: (_column$meta$type = (_column$meta2 = column.meta) === null || _column$meta2 === void 0 ? void 0 : _column$meta2.type) !== null && _column$meta$type !== void 0 ? _column$meta$type : 'unknown',
    esTypes: esType ? [esType] : undefined,
    searchable: true,
    aggregatable: false,
    isNull: Boolean(column === null || column === void 0 ? void 0 : column.isNull),
    ...(timeSeriesMetric ? {
      timeSeriesMetric
    } : {})
  };
}