"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  SUPPORTED_ENTRY_TYPE: true,
  isSupportedFile: true,
  getEntryTypeByFile: true,
  isSupportedEntryType: true,
  contentPackManifestSchema: true
};
exports.isSupportedFile = exports.isSupportedEntryType = exports.getEntryTypeByFile = exports.contentPackManifestSchema = exports.SUPPORTED_ENTRY_TYPE = void 0;
var _path = _interopRequireDefault(require("path"));
var _zod = require("@kbn/zod");
var _saved_object = require("./saved_object");
Object.keys(_saved_object).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _saved_object[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _saved_object[key];
    }
  });
});
var _api = require("./api");
Object.keys(_api).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _api[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _api[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUPPORTED_ENTRY_TYPE = exports.SUPPORTED_ENTRY_TYPE = {
  ..._saved_object.SUPPORTED_SAVED_OBJECT_TYPE
};
const isSupportedFile = (rootDir, filepath) => {
  return Object.values(SUPPORTED_ENTRY_TYPE).some(dir => _path.default.dirname(filepath) === _path.default.join(rootDir, 'kibana', dir));
};
exports.isSupportedFile = isSupportedFile;
const getEntryTypeByFile = (rootDir, filepath) => {
  const entry = Object.entries(SUPPORTED_ENTRY_TYPE).find(([t, dir]) => _path.default.dirname(filepath) === _path.default.join(rootDir, 'kibana', dir));
  if (!entry) {
    throw new Error(`Unknown entry type for filepath [${filepath}]`);
  }
  return entry[0];
};
exports.getEntryTypeByFile = getEntryTypeByFile;
const isSupportedEntryType = type => {
  return type in SUPPORTED_ENTRY_TYPE;
};
exports.isSupportedEntryType = isSupportedEntryType;
const contentPackManifestSchema = exports.contentPackManifestSchema = _zod.z.object({
  name: _zod.z.string(),
  description: _zod.z.string(),
  version: _zod.z.string()
});