"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBenchmarkIdQuery = exports.BenchmarksSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _use_navigate_findings = require("@kbn/cloud-security-posture/src/hooks/use_navigate_findings");
var _risks_table = require("../compliance_charts/risks_table");
var _constants = require("../../../../common/constants");
var _constants2 = require("../../../common/constants");
var _summary_section = require("./summary_section");
var _test_subjects = require("../test_subjects");
var _compliance_score_chart = require("../compliance_charts/compliance_score_chart");
var _benchmark_details_box = require("./benchmark_details_box");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BENCHMARK_DEFAULT_SORT_ORDER = 'asc';
const getBenchmarkIdQuery = (benchmark, activeNamespace) => {
  return activeNamespace ? {
    [_constants2.FINDINGS_FILTER_OPTIONS.RULE_BENCHMARK_ID]: benchmark.meta.benchmarkId,
    [_constants2.FINDINGS_FILTER_OPTIONS.RULE_BENCHMARK_VERSION]: benchmark.meta.benchmarkVersion,
    [_constants2.FINDINGS_FILTER_OPTIONS.NAMESPACE]: activeNamespace
  } : {
    [_constants2.FINDINGS_FILTER_OPTIONS.RULE_BENCHMARK_ID]: benchmark.meta.benchmarkId,
    [_constants2.FINDINGS_FILTER_OPTIONS.RULE_BENCHMARK_VERSION]: benchmark.meta.benchmarkVersion
  };
};
exports.getBenchmarkIdQuery = getBenchmarkIdQuery;
const BenchmarksSection = ({
  complianceData,
  dashboardType,
  activeNamespace
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const navToFindings = (0, _use_navigate_findings.useNavigateFindings)();
  const [benchmarkSorting, setBenchmarkSorting] = (0, _useLocalStorage.default)(_constants2.LOCAL_STORAGE_DASHBOARD_BENCHMARK_SORT_KEY, BENCHMARK_DEFAULT_SORT_ORDER);
  const isBenchmarkSortingAsc = benchmarkSorting === 'asc';
  const benchmarkSortingIcon = isBenchmarkSortingAsc ? 'sortUp' : 'sortDown';
  const navToFindingsByBenchmarkAndEvaluation = (benchmark, evaluation, groupBy = [_constants2.FINDINGS_GROUPING_OPTIONS.NONE]) => navToFindings({
    ...(0, _summary_section.getPolicyTemplateQuery)(dashboardType, activeNamespace),
    ...getBenchmarkIdQuery(benchmark, activeNamespace),
    [_constants2.FINDINGS_FILTER_OPTIONS.RESULT_EVALUATION]: evaluation
  }, groupBy);
  const navToFailedFindingsByBenchmarkAndSection = (benchmark, ruleSection, resultEvaluation = _constants.RULE_FAILED) => navToFindings({
    ...(0, _summary_section.getPolicyTemplateQuery)(dashboardType, activeNamespace),
    ...getBenchmarkIdQuery(benchmark, activeNamespace),
    [_constants2.FINDINGS_FILTER_OPTIONS.RULE_SECTION]: ruleSection,
    [_constants2.FINDINGS_FILTER_OPTIONS.RESULT_EVALUATION]: resultEvaluation
  }, [_constants2.FINDINGS_GROUPING_OPTIONS.NONE]);
  const navToFailedFindingsByBenchmark = benchmark => {
    navToFindingsByBenchmarkAndEvaluation(benchmark, _constants.RULE_FAILED, [_constants2.FINDINGS_GROUPING_OPTIONS.RULE_SECTION]);
  };
  const toggleBenchmarkSortingDirection = () => {
    setBenchmarkSorting(isBenchmarkSortingAsc ? 'desc' : 'asc');
  };
  const benchmarks = (0, _react.useMemo)(() => {
    return [...complianceData.benchmarks].sort((benchmarkA, benchmarkB) => isBenchmarkSortingAsc ? benchmarkA.stats.postureScore - benchmarkB.stats.postureScore : benchmarkB.stats.postureScore - benchmarkA.stats.postureScore);
  }, [complianceData.benchmarks, isBenchmarkSortingAsc]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
         border-bottom: ${euiTheme.border.thin};
         border-bottom-color: ${euiTheme.colors.lightShade};
         padding-bottom: ${euiTheme.size.s};
        .euiTitle {
          font-weight: ${euiTheme.font.weight.semiBold};
        };
        button {
          text-align: left;
        },
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: _summary_section.dashboardColumnsGrow.first
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.dashboard.benchmarkSection.columnsHeader.benchmarks",
    defaultMessage: "Benchmarks"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: _summary_section.dashboardColumnsGrow.second
  }, /*#__PURE__*/_react.default.createElement("button", {
    "data-test-subj": _test_subjects.DASHBOARD_TABLE_HEADER_SCORE_TEST_ID,
    onClick: toggleBenchmarkSortingDirection
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.dashboard.benchmarkSection.columnsHeader.complianceScoreTitle",
    defaultMessage: "Compliance Score"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: benchmarkSortingIcon
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: _summary_section.dashboardColumnsGrow.third
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.dashboard.benchmarkSection.columnsHeader.complianceByCisSectionTitle",
    defaultMessage: "Compliance by CIS Section"
  }))))), benchmarks.map(benchmark => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    key: `${benchmark.meta.benchmarkId}_${benchmark.meta.benchmarkVersion}`,
    css: (0, _react2.css)`
            // card height with 3 items in risk table
            height: 200px;
            padding: ${euiTheme.size.base} 0 ${euiTheme.size.l};
            &:not(:last-of-type) {
              border-bottom: ${euiTheme.border.thin};
            }
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: _summary_section.dashboardColumnsGrow.first
  }, /*#__PURE__*/_react.default.createElement(_benchmark_details_box.BenchmarkDetailsBox, {
    benchmark: benchmark,
    activeNamespace: activeNamespace
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: _summary_section.dashboardColumnsGrow.second,
    css: (0, _react2.css)`
              margin-left: -${euiTheme.size.s};
            `,
    "data-test-subj": _test_subjects.DASHBOARD_TABLE_COLUMN_SCORE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_compliance_score_chart.ComplianceScoreChart, {
    compact: true,
    id: `${benchmark.meta.benchmarkId}_score_chart`,
    data: benchmark.stats,
    trend: benchmark.trend,
    onEvalCounterClick: evaluation => navToFindingsByBenchmarkAndEvaluation(benchmark, evaluation)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: _summary_section.dashboardColumnsGrow.third
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      paddingRight: euiTheme.size.base
    }
  }, /*#__PURE__*/_react.default.createElement(_risks_table.RisksTable, {
    compact: true,
    data: benchmark.groupedFindingsEvaluation,
    maxItems: 3,
    onCellClick: resourceTypeName => {
      const cisSectionEvaluation = benchmark.groupedFindingsEvaluation.find(groupedFindingsEvaluation => groupedFindingsEvaluation.name === resourceTypeName);
      // if the CIS Section posture score is 100, we should navigate with result evaluation as passed or result evaluation as failed
      if (cisSectionEvaluation !== null && cisSectionEvaluation !== void 0 && cisSectionEvaluation.postureScore && Math.trunc(cisSectionEvaluation === null || cisSectionEvaluation === void 0 ? void 0 : cisSectionEvaluation.postureScore) === 100) {
        navToFailedFindingsByBenchmarkAndSection(benchmark, resourceTypeName, _constants.RULE_PASSED);
      } else {
        navToFailedFindingsByBenchmarkAndSection(benchmark, resourceTypeName);
      }
    },
    viewAllButtonTitle: _i18n.i18n.translate('xpack.csp.dashboard.risksTable.benchmarkCardViewAllButtonTitle', {
      defaultMessage: 'View all failed findings for this benchmark'
    }),
    onViewAllClick: () => navToFailedFindingsByBenchmark(benchmark)
  }))))));
};
exports.BenchmarksSection = BenchmarksSection;