"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInputVarsFields = exports.getAwsCredentialsFormOptions = exports.getAwsCredentialsFormManualOptions = exports.getAwsCredentialsFormAgentlessOptions = exports.getAwsCloudConnectorsFormAgentlessOptions = exports.getAwsCloudConnectorsCredentialsFormOptions = exports.getAwsAgentlessFormOptions = exports.getAgentlessCredentialsType = exports.DEFAULT_MANUAL_AWS_CREDENTIALS_TYPE = exports.DEFAULT_AWS_CREDENTIALS_TYPE = exports.DEFAULT_AGENTLESS_CLOUD_CONNECTORS_AWS_CREDENTIALS_TYPE = exports.DEFAULT_AGENTLESS_AWS_CREDENTIALS_TYPE = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _aws_credentials_form = require("./aws_credentials_form");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssumeRoleDescription = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.awsIntegration.assumeRoleDescription",
  defaultMessage: "An IAM role Amazon Resource Name (ARN) is an IAM identity that you can create in your AWS account. When creating an IAM role, users can define the role\u2019s permissions. Roles do not have standard long-term credentials such as passwords or access keys."
})));
const DirectAccessKeysDescription = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.awsIntegration.directAccessKeysDescription",
  defaultMessage: "Access keys are long-term credentials for an IAM user or the AWS account root user."
})));
const TemporaryKeysDescription = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.awsIntegration.temporaryKeysDescription",
  defaultMessage: "You can configure temporary security credentials in AWS to last for a specified duration. They consist of an access key ID, a secret access key, and a security token, which is typically found using GetSessionToken."
})));
const SharedCredentialsDescription = /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: 'subdued',
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.awsIntegration.sharedCredentialsDescription",
  defaultMessage: "If you use different AWS credentials for different tools or applications, you can use profiles to define multiple access keys in the same configuration file."
})));
const AWS_FIELD_LABEL = {
  access_key_id: _i18n.i18n.translate('xpack.csp.awsIntegration.accessKeyIdLabel', {
    defaultMessage: 'Access Key ID'
  }),
  secret_access_key: _i18n.i18n.translate('xpack.csp.awsIntegration.secretAccessKeyLabel', {
    defaultMessage: 'Secret Access Key'
  })
};
const getInputVarsFields = (input, fields) => Object.entries(input.streams[0].vars || {}).filter(([id]) => id in fields).map(([id, inputVar]) => {
  const field = fields[id];
  return {
    id,
    label: field.label,
    type: field.type || 'text',
    value: inputVar.value,
    dataTestSubj: field.dataTestSubj,
    isSecret: field.isSecret
  };
});
exports.getInputVarsFields = getInputVarsFields;
const getAgentlessCredentialsType = (postureInput, showCloudConnectors) => {
  const credentialsType = (0, _utils.getAwsCredentialsType)(postureInput);
  if (!credentialsType && showCloudConnectors || credentialsType === _aws_credentials_form.AWS_CREDENTIALS_TYPE.CLOUD_FORMATION && showCloudConnectors) {
    return _aws_credentials_form.AWS_CREDENTIALS_TYPE.CLOUD_CONNECTORS;
  }
  if (credentialsType === _aws_credentials_form.AWS_CREDENTIALS_TYPE.CLOUD_FORMATION || !credentialsType) {
    return _aws_credentials_form.AWS_CREDENTIALS_TYPE.DIRECT_ACCESS_KEYS;
  }
  return credentialsType;
};
exports.getAgentlessCredentialsType = getAgentlessCredentialsType;
const getAwsCredentialsTypeSelectorOptions = (filterFn, getFormOptions = getAwsCredentialsFormOptions) => {
  return Object.entries(getFormOptions()).map(([key, value]) => ({
    value: key,
    text: value.label
  })).filter(filterFn);
};
const getAwsCredentialsFormManualOptions = () => getAwsCredentialsTypeSelectorOptions(({
  value
}) => value !== _aws_credentials_form.AWS_CREDENTIALS_TYPE.CLOUD_FORMATION);
exports.getAwsCredentialsFormManualOptions = getAwsCredentialsFormManualOptions;
const getAwsCredentialsFormAgentlessOptions = () => getAwsCredentialsTypeSelectorOptions(({
  value
}) => value === _aws_credentials_form.AWS_CREDENTIALS_TYPE.DIRECT_ACCESS_KEYS || value === _aws_credentials_form.AWS_CREDENTIALS_TYPE.TEMPORARY_KEYS, getAwsAgentlessFormOptions);
exports.getAwsCredentialsFormAgentlessOptions = getAwsCredentialsFormAgentlessOptions;
const getAwsCloudConnectorsFormAgentlessOptions = () => getAwsCredentialsTypeSelectorOptions(({
  value
}) => value === _aws_credentials_form.AWS_CREDENTIALS_TYPE.CLOUD_CONNECTORS || value === _aws_credentials_form.AWS_CREDENTIALS_TYPE.DIRECT_ACCESS_KEYS || value === _aws_credentials_form.AWS_CREDENTIALS_TYPE.TEMPORARY_KEYS, getAwsCloudConnectorsCredentialsFormOptions);
exports.getAwsCloudConnectorsFormAgentlessOptions = getAwsCloudConnectorsFormAgentlessOptions;
const DEFAULT_AWS_CREDENTIALS_TYPE = exports.DEFAULT_AWS_CREDENTIALS_TYPE = _aws_credentials_form.AWS_CREDENTIALS_TYPE.CLOUD_FORMATION;
const DEFAULT_MANUAL_AWS_CREDENTIALS_TYPE = exports.DEFAULT_MANUAL_AWS_CREDENTIALS_TYPE = _aws_credentials_form.AWS_CREDENTIALS_TYPE.ASSUME_ROLE;
const DEFAULT_AGENTLESS_AWS_CREDENTIALS_TYPE = exports.DEFAULT_AGENTLESS_AWS_CREDENTIALS_TYPE = _aws_credentials_form.AWS_CREDENTIALS_TYPE.DIRECT_ACCESS_KEYS;
const DEFAULT_AGENTLESS_CLOUD_CONNECTORS_AWS_CREDENTIALS_TYPE = exports.DEFAULT_AGENTLESS_CLOUD_CONNECTORS_AWS_CREDENTIALS_TYPE = _aws_credentials_form.AWS_CREDENTIALS_TYPE.CLOUD_CONNECTORS;
const getAwsCredentialsFormOptions = () => ({
  [_aws_credentials_form.AWS_CREDENTIALS_TYPE.ASSUME_ROLE]: {
    label: _i18n.i18n.translate('xpack.csp.awsIntegration.assumeRoleLabel', {
      defaultMessage: 'Assume role'
    }),
    info: AssumeRoleDescription,
    fields: {
      role_arn: {
        label: _i18n.i18n.translate('xpack.csp.awsIntegration.roleArnLabel', {
          defaultMessage: 'Role ARN'
        }),
        dataTestSubj: 'awsRoleArnInput'
      }
    }
  },
  [_aws_credentials_form.AWS_CREDENTIALS_TYPE.DIRECT_ACCESS_KEYS]: {
    label: _i18n.i18n.translate('xpack.csp.awsIntegration.directAccessKeyLabel', {
      defaultMessage: 'Direct access keys'
    }),
    info: DirectAccessKeysDescription,
    fields: {
      access_key_id: {
        label: AWS_FIELD_LABEL.access_key_id,
        dataTestSubj: 'awsDirectAccessKeyId'
      },
      secret_access_key: {
        label: AWS_FIELD_LABEL.secret_access_key,
        type: 'password',
        dataTestSubj: 'awsDirectAccessSecretKey',
        isSecret: true
      }
    }
  },
  [_aws_credentials_form.AWS_CREDENTIALS_TYPE.TEMPORARY_KEYS]: {
    info: TemporaryKeysDescription,
    label: _i18n.i18n.translate('xpack.csp.awsIntegration.temporaryKeysLabel', {
      defaultMessage: 'Temporary keys'
    }),
    fields: {
      access_key_id: {
        label: AWS_FIELD_LABEL.access_key_id,
        dataTestSubj: 'awsTemporaryKeysAccessKeyId'
      },
      secret_access_key: {
        label: AWS_FIELD_LABEL.secret_access_key,
        type: 'password',
        dataTestSubj: 'awsTemporaryKeysSecretAccessKey',
        isSecret: true
      },
      session_token: {
        label: _i18n.i18n.translate('xpack.csp.awsIntegration.sessionTokenLabel', {
          defaultMessage: 'Session Token'
        }),
        dataTestSubj: 'awsTemporaryKeysSessionToken'
      }
    }
  },
  [_aws_credentials_form.AWS_CREDENTIALS_TYPE.SHARED_CREDENTIALS]: {
    label: _i18n.i18n.translate('xpack.csp.awsIntegration.sharedCredentialLabel', {
      defaultMessage: 'Shared credentials'
    }),
    info: SharedCredentialsDescription,
    fields: {
      shared_credential_file: {
        label: _i18n.i18n.translate('xpack.csp.awsIntegration.sharedCredentialFileLabel', {
          defaultMessage: 'Shared Credential File'
        }),
        dataTestSubj: 'awsSharedCredentialFile'
      },
      credential_profile_name: {
        label: _i18n.i18n.translate('xpack.csp.awsIntegration.credentialProfileNameLabel', {
          defaultMessage: 'Credential Profile Name'
        }),
        dataTestSubj: 'awsCredentialProfileName'
      }
    }
  },
  [_aws_credentials_form.AWS_CREDENTIALS_TYPE.CLOUD_FORMATION]: {
    label: 'CloudFormation',
    info: [],
    fields: {}
  }
});
exports.getAwsCredentialsFormOptions = getAwsCredentialsFormOptions;
const getAwsCloudConnectorsCredentialsFormOptions = () => ({
  [_aws_credentials_form.AWS_CREDENTIALS_TYPE.CLOUD_CONNECTORS]: {
    label: _i18n.i18n.translate('xpack.csp.awsIntegration.cloudConnectorsRoleLabel', {
      defaultMessage: 'Cloud Connectors (recommended)'
    }),
    info: AssumeRoleDescription,
    fields: {
      role_arn: {
        label: _i18n.i18n.translate('xpack.csp.awsIntegration.roleArnLabel', {
          defaultMessage: 'Role ARN'
        }),
        type: 'text',
        dataTestSubj: 'awsRoleArnInput'
      },
      'aws.credentials.external_id': {
        label: _i18n.i18n.translate('xpack.csp.awsIntegration.externalId', {
          defaultMessage: 'External ID'
        }),
        type: 'password',
        dataTestSubj: 'awsExternalId',
        isSecret: true
      }
    }
  },
  [_aws_credentials_form.AWS_CREDENTIALS_TYPE.DIRECT_ACCESS_KEYS]: {
    label: _i18n.i18n.translate('xpack.csp.awsIntegration.directAccessKeyLabel', {
      defaultMessage: 'Direct access keys'
    }),
    info: DirectAccessKeysDescription,
    fields: {
      access_key_id: {
        label: AWS_FIELD_LABEL.access_key_id,
        dataTestSubj: 'awsDirectAccessKeyId'
      },
      secret_access_key: {
        label: AWS_FIELD_LABEL.secret_access_key,
        type: 'password',
        dataTestSubj: 'awsDirectAccessSecretKey',
        isSecret: true
      }
    }
  },
  [_aws_credentials_form.AWS_CREDENTIALS_TYPE.TEMPORARY_KEYS]: {
    info: TemporaryKeysDescription,
    label: _i18n.i18n.translate('xpack.csp.awsIntegration.temporaryKeysLabel', {
      defaultMessage: 'Temporary keys'
    }),
    fields: {
      access_key_id: {
        label: AWS_FIELD_LABEL.access_key_id,
        dataTestSubj: 'awsTemporaryKeysAccessKeyId'
      },
      secret_access_key: {
        label: AWS_FIELD_LABEL.secret_access_key,
        type: 'password',
        dataTestSubj: 'awsTemporaryKeysSecretAccessKey',
        isSecret: true
      },
      session_token: {
        label: _i18n.i18n.translate('xpack.csp.awsIntegration.sessionTokenLabel', {
          defaultMessage: 'Session Token'
        }),
        dataTestSubj: 'awsTemporaryKeysSessionToken'
      }
    }
  }
});
exports.getAwsCloudConnectorsCredentialsFormOptions = getAwsCloudConnectorsCredentialsFormOptions;
const getAwsAgentlessFormOptions = () => ({
  [_aws_credentials_form.AWS_CREDENTIALS_TYPE.DIRECT_ACCESS_KEYS]: {
    label: _i18n.i18n.translate('xpack.csp.awsIntegration.directAccessKeyLabel', {
      defaultMessage: 'Direct access keys'
    }),
    info: DirectAccessKeysDescription,
    fields: {
      access_key_id: {
        label: AWS_FIELD_LABEL.access_key_id,
        dataTestSubj: 'awsDirectAccessKeyId'
      },
      secret_access_key: {
        label: AWS_FIELD_LABEL.secret_access_key,
        type: 'password',
        dataTestSubj: 'awsDirectAccessSecretKey',
        isSecret: true
      }
    }
  },
  [_aws_credentials_form.AWS_CREDENTIALS_TYPE.TEMPORARY_KEYS]: {
    info: TemporaryKeysDescription,
    label: _i18n.i18n.translate('xpack.csp.awsIntegration.temporaryKeysLabel', {
      defaultMessage: 'Temporary keys'
    }),
    fields: {
      access_key_id: {
        label: AWS_FIELD_LABEL.access_key_id,
        dataTestSubj: 'awsTemporaryKeysAccessKeyId'
      },
      secret_access_key: {
        label: AWS_FIELD_LABEL.secret_access_key,
        type: 'password',
        dataTestSubj: 'awsTemporaryKeysSecretAccessKey',
        isSecret: true
      },
      session_token: {
        label: _i18n.i18n.translate('xpack.csp.awsIntegration.sessionTokenLabel', {
          defaultMessage: 'Session Token'
        }),
        dataTestSubj: 'awsTemporaryKeysSessionToken'
      }
    }
  }
});
exports.getAwsAgentlessFormOptions = getAwsAgentlessFormOptions;