"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAvailableCasesOwners = void 0;
var _constants = require("../../../common/constants");
var _kibana = require("../../common/lib/kibana");
var _permissions = require("../../utils/permissions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 *
 * @param capabilities : specifies the requirements for a valid owner, an owner will be included if it has the specified
 *  capabilities
 **/

const useAvailableCasesOwners = (capabilities = _permissions.allCasePermissions) => {
  const {
    capabilities: kibanaCapabilities
  } = (0, _kibana.useKibana)().services.application;
  return Object.entries(kibanaCapabilities).reduce((availableOwners, [featureId, kibanaCapability]) => {
    if (!featureId.endsWith('CasesV3')) {
      return availableOwners;
    }
    for (const cap of capabilities) {
      const hasCapability = !!kibanaCapability[`${cap}_cases`] || !!kibanaCapability[`cases_${cap}`];
      if (!hasCapability) {
        return availableOwners;
      }
    }
    availableOwners.push(getOwnerFromFeatureID(featureId));
    return availableOwners;
  }, []);
};
exports.useAvailableCasesOwners = useAvailableCasesOwners;
const getOwnerFromFeatureID = featureID => {
  if (featureID === _constants.FEATURE_ID_V3) {
    return _constants.APP_ID;
  }
  return featureID.replace('CasesV3', '');
};