"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hostNamesToKuery = hostNamesToKuery;
var _lodash = require("lodash");
var _apm = require("../../../common/es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function hostNamesToKuery(hostNames) {
  return hostNames.reduce((acc, hostName) => {
    if ((0, _lodash.isEmpty)(acc)) {
      return `${_apm.HOST_NAME} : "${hostName}"`;
    }
    return `${acc} OR ${_apm.HOST_NAME} : "${hostName}"`;
  }, '');
}