"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePreviousPeriodLabel = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _use_apm_params = require("./use_apm_params");
var _use_time_range = require("./use_time_range");
var _get_comparison_options = require("../components/shared/time_comparison/get_comparison_options");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fallbackPreviousPeriodText = _i18n.i18n.translate('xpack.apm.chart.comparison.defaultPreviousPeriodLabel', {
  defaultMessage: 'Previous period'
});
const usePreviousPeriodLabel = () => {
  const {
    query: {
      rangeFrom,
      rangeTo,
      offset
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services', '/dependencies/*', '/services/{serviceName}', '/mobile-services/{serviceName}/*');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const previousPeriodText = (0, _react.useMemo)(() => {
    var _timeComparisonOption, _timeComparisonOption2;
    const timeComparisonOptions = (0, _get_comparison_options.getComparisonOptions)({
      start,
      end
    });
    const comparisonPeriodText = (_timeComparisonOption = (_timeComparisonOption2 = timeComparisonOptions.find(d => d.value === offset || d.value.endsWith('ms'))) === null || _timeComparisonOption2 === void 0 ? void 0 : _timeComparisonOption2.text) !== null && _timeComparisonOption !== void 0 ? _timeComparisonOption : fallbackPreviousPeriodText;
    return comparisonPeriodText;
  }, [start, end, offset]);
  return previousPeriodText;
};
exports.usePreviousPeriodLabel = usePreviousPeriodLabel;