"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataUsagePlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("../common");
var _translations = require("./translations");
var _experimental_features = require("../common/experimental_features");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class DataUsagePlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "experimentalFeatures", void 0);
    this.initializerContext = initializerContext;
    this.config = this.initializerContext.config.get();
    this.experimentalFeatures = {};
  }
  setup(core, plugins) {
    const {
      management
    } = plugins;
    this.experimentalFeatures = (0, _experimental_features.parseExperimentalConfigValue)(this.config.enableExperimental).features;
    const experimentalFeatures = this.experimentalFeatures;
    if (!experimentalFeatures.dataUsageDisabled) {
      management.sections.section.data.registerApp({
        id: _common.PLUGIN_ID,
        title: _translations.PLUGIN_NAME,
        order: 6,
        keywords: ['data usage', 'usage'],
        async mount(params) {
          const [{
            renderApp
          }, [coreStart, pluginsStartDeps, pluginStart]] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('./application'))), core.getStartServices()]);
          return renderApp(coreStart, pluginsStartDeps, pluginStart, params);
        }
      });
    }
    return {};
  }
  start(_core, plugins) {
    return {};
  }
  stop() {}
}
exports.DataUsagePlugin = DataUsagePlugin;