"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerEluHistoryRoute = registerEluHistoryRoute;
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Intended for exposing metrics over HTTP that we do not want to include in the /api/stats endpoint, yet.
 */
function registerEluHistoryRoute(router, elu) {
  // Report the same metrics to APM
  _elasticApmNode.default.registerMetric('elu.history.short', () => elu().short);
  _elasticApmNode.default.registerMetric('elu.history.medium', () => elu().medium);
  _elasticApmNode.default.registerMetric('elu.history.long', () => elu().long);
  router.versioned.get({
    access: 'internal',
    enableQueryVersion: true,
    path: '/api/_elu_history',
    options: {
      excludeFromRateLimiter: true
    },
    security: {
      authz: {
        enabled: false,
        reason: 'This route is used for internal monitoring and does not require authorization.'
      },
      authc: {
        enabled: false,
        reason: 'This route is used for internal monitoring and does not require authentication.'
      }
    }
  }).addVersion({
    version: '1',
    validate: false
  }, async (ctx, req, res) => {
    const body = {
      history: elu()
    };
    return res.ok({
      body
    });
  });
}