"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _ops_metrics_collector = require("./ops_metrics_collector");
var _ops_config = require("./ops_config");
var _logging = require("./logging");
var _elu_history = require("./routes/elu_history");
var _exponential_moving_average = require("./exponential_moving_average");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ELU_SHORT = 15000;
const ELU_MEDIUM = 30000;
const ELU_LONG = 60000;

/** @internal */

/** @internal */

/** @internal */
class MetricsService {
  constructor(coreContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "opsMetricsLogger", void 0);
    (0, _defineProperty2.default)(this, "metricsCollector", void 0);
    (0, _defineProperty2.default)(this, "collectInterval", void 0);
    (0, _defineProperty2.default)(this, "metrics$", new _rxjs.ReplaySubject(1));
    (0, _defineProperty2.default)(this, "elu$", new _rxjs.BehaviorSubject({
      long: 0,
      medium: 0,
      short: 0
    }));
    (0, _defineProperty2.default)(this, "service", void 0);
    this.coreContext = coreContext;
    this.logger = coreContext.logger.get('metrics');
    this.opsMetricsLogger = coreContext.logger.get('metrics', 'ops');
  }
  async setup({
    http,
    elasticsearchService
  }) {
    const config = await (0, _rxjs.firstValueFrom)(this.coreContext.configService.atPath(_ops_config.OPS_CONFIG_PATH));
    const collectionInterval = config.interval.asMilliseconds();
    this.metricsCollector = new _ops_metrics_collector.OpsMetricsCollector(http.server, elasticsearchService.agentStatsProvider, {
      logger: this.logger,
      ...config.cGroupOverrides
    });
    this.metricsCollector.registerMetrics();
    await this.refreshMetrics();
    this.collectInterval = setInterval(() => {
      this.refreshMetrics();
    }, collectionInterval);
    this.metrics$.pipe((0, _rxjs.map)(metrics => metrics.process.event_loop_utilization.utilization), elu$ => (0, _rxjs.zip)(elu$.pipe((0, _exponential_moving_average.exponentialMovingAverage)(ELU_SHORT, collectionInterval)), elu$.pipe((0, _exponential_moving_average.exponentialMovingAverage)(ELU_MEDIUM, collectionInterval)), elu$.pipe((0, _exponential_moving_average.exponentialMovingAverage)(ELU_LONG, collectionInterval))).pipe((0, _rxjs.map)(([short, medium, long]) => ({
      short,
      medium,
      long
    })))).subscribe(this.elu$);
    (0, _elu_history.registerEluHistoryRoute)(http.createRouter(''), () => this.elu$.value);
    this.service = {
      collectionInterval,
      getOpsMetrics$: () => this.metrics$,
      getEluMetrics$: () => this.elu$
    };
    return this.service;
  }
  async start() {
    if (!this.service) {
      throw new Error('#setup() needs to be run first');
    }
    return this.service;
  }
  async refreshMetrics() {
    const metrics = await this.metricsCollector.collect();
    if (this.opsMetricsLogger.isLevelEnabled('debug')) {
      const {
        message,
        meta
      } = (0, _logging.getEcsOpsMetricsLog)(metrics);
      this.opsMetricsLogger.debug(message, meta);
    }
    this.metricsCollector.reset();
    this.metrics$.next(metrics);
  }
  async stop() {
    if (this.collectInterval) {
      clearInterval(this.collectInterval);
    }
    this.metrics$.complete();
  }
}
exports.MetricsService = MetricsService;