"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexDetails = exports.extractVersionFromKibanaIndexAliases = void 0;
var _semver = require("semver");
var _coreElasticsearchServerInternal = require("@kbn/core-elasticsearch-server-internal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getIndexDetails = async (client, index, retryDelay = 2500) => {
  const [mappingResponse, aliasResponse] = await Promise.all([(0, _coreElasticsearchServerInternal.migrationRetryCallCluster)(() => client.indices.getMapping({
    index
  }), retryDelay), (0, _coreElasticsearchServerInternal.migrationRetryCallCluster)(() => client.indices.getAlias({
    index
  }), retryDelay)]);

  // { '.kibana_9.1.0_001': { mappings: { ... } }
  const mappings = Object.values(mappingResponse)[0].mappings;

  // { '.kibana_9.1.0_001': { aliases: { '.kibana': [Object], '.kibana_9.1.0': [Object] } }
  const aliases = Object.keys(Object.values(aliasResponse)[0].aliases);
  return {
    mappings,
    aliases
  };
};
exports.getIndexDetails = getIndexDetails;
const extractVersionFromKibanaIndexAliases = aliases => {
  const versions = aliases.map(alias => alias.split('_').pop()).filter(version => (0, _semver.valid)(version)).map(version => new _semver.SemVer(version));
  if (versions.length === 0) {
    // the version aliases were introduced in 7.11.0
    return undefined;
  } else if (versions.length === 1) {
    return versions[0].toString();
  } else {
    // an index shouldn't have more than one version alias pointing to it
    // but we'll get the latest just in case
    return versions.sort((a, b) => a.compare(b)).pop().toString();
  }
};
exports.extractVersionFromKibanaIndexAliases = extractVersionFromKibanaIndexAliases;