"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.chaining$ = chaining$;
var _rxjs = require("rxjs");
var _presentationPublishing = require("@kbn/presentation-publishing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function chaining$(uuid, chainingSystem$, controlsInOrder$, children$) {
  return (0, _rxjs.combineLatest)([chainingSystem$, controlsInOrder$, children$]).pipe((0, _rxjs.skipWhile)(([chainingSystem, controlsInOrder, children]) => {
    if (chainingSystem === 'HIERARCHICAL') {
      for (let i = 0; i < controlsInOrder.length; i++) {
        if (controlsInOrder[i].id === uuid) {
          // all controls to the left are initialized
          return false;
        }
        if (!children[controlsInOrder[i].id]) {
          // a control to the left is not initialized
          // block rxjs pipe flow until its initialized
          return true;
        }
      }
    }

    // no chaining
    return false;
  }), (0, _rxjs.switchMap)(([chainingSystem, controlsInOrder, children]) => {
    const observables = [];
    if (chainingSystem === 'HIERARCHICAL') {
      for (let i = 0; i < controlsInOrder.length; i++) {
        if (controlsInOrder[i].id === uuid) {
          break;
        }
        const chainedControlApi = children[controlsInOrder[i].id];
        const chainedControl$ = (0, _rxjs.combineLatest)([(0, _presentationPublishing.apiPublishesFilters)(chainedControlApi) ? chainedControlApi.filters$ : new _rxjs.BehaviorSubject(undefined), (0, _presentationPublishing.apiPublishesTimeslice)(chainedControlApi) ? chainedControlApi.timeslice$ : new _rxjs.BehaviorSubject(undefined)]).pipe((0, _rxjs.map)(([filters, timeslice]) => {
          return {
            filters,
            timeslice
          };
        }));
        observables.push(chainedControl$);
      }
    }
    return observables.length ? (0, _rxjs.combineLatest)(observables) : new _rxjs.BehaviorSubject([]);
  }), (0, _rxjs.debounceTime)(0), (0, _rxjs.map)(chainedControlValues => {
    const chainingFilters = [];
    let timeRange;
    chainedControlValues.forEach(chainedControlValue => {
      if (chainedControlValue.filters && chainedControlValue.filters.length) {
        chainingFilters.push(...chainedControlValue.filters);
      }
      if (chainedControlValue.timeslice) {
        timeRange = {
          from: new Date(chainedControlValue.timeslice[0]).toISOString(),
          to: new Date(chainedControlValue.timeslice[1]).toISOString(),
          mode: 'absolute'
        };
      }
    });
    return {
      chainingFilters,
      timeRange
    };
  }));
}