"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupStatsRenderer = exports.groupPanelRenderer = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _helpers = require("../../../common/utils/helpers");
var _test_subjects = require("./test_subjects");
var _translations = require("./translations");
var _cloud_security_grouping = require("../../components/cloud_security_grouping");
var _vulnerability_severity_map = require("../../components/vulnerability_severity_map");
var _cloud_provider_icon = require("../../components/cloud_provider_icon");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const groupPanelRenderer = (selectedGroup, bucket, nullGroupMessage, isLoading) => {
  var _bucket$cloudProvider, _bucket$cloudProvider2, _bucket$cloudProvider3, _bucket$description, _bucket$description$b, _bucket$description$b2, _bucket$resourceName, _bucket$resourceName$, _bucket$resourceName$2, _bucket$resourceName2, _bucket$resourceName3, _bucket$resourceName4;
  if (isLoading) {
    return /*#__PURE__*/_react2.default.createElement(_cloud_security_grouping.LoadingGroup, null);
  }
  const renderNullGroup = title => /*#__PURE__*/_react2.default.createElement(_cloud_security_grouping.NullGroup, {
    title: title,
    field: selectedGroup,
    unit: _translations.NULL_GROUPING_UNIT
  });
  const cloudProvider = (0, _cloud_security_grouping.firstNonNullValue)((_bucket$cloudProvider = bucket.cloudProvider) === null || _bucket$cloudProvider === void 0 ? void 0 : (_bucket$cloudProvider2 = _bucket$cloudProvider.buckets) === null || _bucket$cloudProvider2 === void 0 ? void 0 : (_bucket$cloudProvider3 = _bucket$cloudProvider2[0]) === null || _bucket$cloudProvider3 === void 0 ? void 0 : _bucket$cloudProvider3.key);
  const description = (0, _cloud_security_grouping.firstNonNullValue)((_bucket$description = bucket.description) === null || _bucket$description === void 0 ? void 0 : (_bucket$description$b = _bucket$description.buckets) === null || _bucket$description$b === void 0 ? void 0 : (_bucket$description$b2 = _bucket$description$b[0]) === null || _bucket$description$b2 === void 0 ? void 0 : _bucket$description$b2.key);
  const cloudProviderName = cloudProvider ? (0, _helpers.getCloudProviderNameFromAbbreviation)(cloudProvider) : '';
  switch (selectedGroup) {
    case _constants.VULNERABILITY_GROUPING_OPTIONS.RESOURCE_ID:
      return nullGroupMessage ? renderNullGroup(_translations.NULL_GROUPING_MESSAGES.RESOURCE_ID) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        css: (0, _react.css)`
                  display: inline;
                `
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextBlockTruncate, {
        lines: 2,
        css: (0, _react.css)`
                      word-break: break-all;
                    `,
        title: (_bucket$resourceName = bucket.resourceName) === null || _bucket$resourceName === void 0 ? void 0 : (_bucket$resourceName$ = _bucket$resourceName.buckets) === null || _bucket$resourceName$ === void 0 ? void 0 : (_bucket$resourceName$2 = _bucket$resourceName$[0]) === null || _bucket$resourceName$2 === void 0 ? void 0 : _bucket$resourceName$2.key
      }, /*#__PURE__*/_react2.default.createElement("strong", null, bucket.key_as_string), " ", (_bucket$resourceName2 = bucket.resourceName) === null || _bucket$resourceName2 === void 0 ? void 0 : (_bucket$resourceName3 = _bucket$resourceName2.buckets) === null || _bucket$resourceName3 === void 0 ? void 0 : (_bucket$resourceName4 = _bucket$resourceName3[0]) === null || _bucket$resourceName4 === void 0 ? void 0 : _bucket$resourceName4.key))))));
    case _constants.VULNERABILITY_GROUPING_OPTIONS.CLOUD_ACCOUNT_ID:
      return nullGroupMessage ? renderNullGroup(_translations.NULL_GROUPING_MESSAGES.CLOUD_ACCOUNT_ID) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center"
      }, cloudProvider && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: 0
      }, /*#__PURE__*/_react2.default.createElement(_cloud_provider_icon.CloudProviderIcon, {
        cloudProvider: cloudProvider
      })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react2.default.createElement("strong", null, bucket.key_as_string))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, cloudProviderName)))));
    default:
      return nullGroupMessage ? renderNullGroup(_translations.NULL_GROUPING_MESSAGES.DEFAULT) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react2.default.createElement("strong", null, bucket.key_as_string))), description && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextBlockTruncate, {
        lines: 1,
        css: (0, _react.css)`
                        word-break: break-all;
                      `
      }, description))))));
  }
};
exports.groupPanelRenderer = groupPanelRenderer;
const VulnerabilitiesCountComponent = ({
  bucket
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: bucket.doc_count
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    css: (0, _react.css)`
          margin-left: ${euiTheme.size.s};
        `,
    color: "hollow",
    "data-test-subj": _test_subjects.VULNERABILITIES_GROUPING_COUNTER
  }, (0, _cloudSecurityPostureCommon.getAbbreviatedNumber)(bucket.doc_count)));
};
const VulnerabilitiesCount = /*#__PURE__*/_react2.default.memo(VulnerabilitiesCountComponent);
const SeverityStatsComponent = ({
  bucket
}) => {
  var _bucket$critical$doc_, _bucket$critical, _bucket$high$doc_coun, _bucket$high, _bucket$medium$doc_co, _bucket$medium, _bucket$low$doc_count, _bucket$low;
  const severityMap = {
    critical: (_bucket$critical$doc_ = (_bucket$critical = bucket.critical) === null || _bucket$critical === void 0 ? void 0 : _bucket$critical.doc_count) !== null && _bucket$critical$doc_ !== void 0 ? _bucket$critical$doc_ : 0,
    high: (_bucket$high$doc_coun = (_bucket$high = bucket.high) === null || _bucket$high === void 0 ? void 0 : _bucket$high.doc_count) !== null && _bucket$high$doc_coun !== void 0 ? _bucket$high$doc_coun : 0,
    medium: (_bucket$medium$doc_co = (_bucket$medium = bucket.medium) === null || _bucket$medium === void 0 ? void 0 : _bucket$medium.doc_count) !== null && _bucket$medium$doc_co !== void 0 ? _bucket$medium$doc_co : 0,
    low: (_bucket$low$doc_count = (_bucket$low = bucket.low) === null || _bucket$low === void 0 ? void 0 : _bucket$low.doc_count) !== null && _bucket$low$doc_count !== void 0 ? _bucket$low$doc_count : 0
  };
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.grouping.severity",
    defaultMessage: "Severity"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_vulnerability_severity_map.VulnerabilitySeverityMap, {
    total: bucket.doc_count,
    severityMap: severityMap
  })));
};
const SeverityStats = /*#__PURE__*/_react2.default.memo(SeverityStatsComponent);
const groupStatsRenderer = (selectedGroup, bucket) => [{
  title: _translations.VULNERABILITIES,
  component: /*#__PURE__*/_react2.default.createElement(VulnerabilitiesCount, {
    bucket: bucket
  })
}, {
  title: '',
  component: /*#__PURE__*/_react2.default.createElement(SeverityStats, {
    bucket: bucket
  })
}];
exports.groupStatsRenderer = groupStatsRenderer;