"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindingsDetectionRuleCounter = void 0;
var _react = _interopRequireDefault(require("react"));
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _create_detection_rule_from_benchmark = require("@kbn/cloud-security-posture/src/utils/create_detection_rule_from_benchmark");
var _detection_rule_counter = require("../../../components/detection_rule_counter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FindingsDetectionRuleCounter = ({
  finding
}) => {
  const createMisconfigurationRuleFn = async http => await (0, _create_detection_rule_from_benchmark.createDetectionRuleFromBenchmarkRule)(http, finding.rule);
  return /*#__PURE__*/_react.default.createElement(_detection_rule_counter.DetectionRuleCounter, {
    tags: (0, _cloudSecurityPostureCommon.getFindingsDetectionRuleSearchTags)(finding.rule),
    createRuleFn: createMisconfigurationRuleFn
  });
};
exports.FindingsDetectionRuleCounter = FindingsDetectionRuleCounter;