"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.builderMap = void 0;
var _domain = require("../../../common/types/domain");
var _configure_text_field = require("./text/configure_text_field");
var _configure_toggle_field = require("./toggle/configure_toggle_field");
var _configure_number_field = require("./number/configure_number_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const builderMap = exports.builderMap = Object.freeze({
  [_domain.CustomFieldTypes.TEXT]: _configure_text_field.configureTextCustomFieldFactory,
  [_domain.CustomFieldTypes.TOGGLE]: _configure_toggle_field.configureToggleCustomFieldFactory,
  [_domain.CustomFieldTypes.NUMBER]: _configure_number_field.configureNumberCustomFieldFactory
});