"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsChart = MetricsChart;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _formatters = require("../../../../../common/utils/formatters");
var _timeseries_chart_with_context = require("../timeseries_chart_with_context");
var _helper = require("../transaction_charts/helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getYTickFormatter(chart) {
  const max = (0, _helper.getMaxY)(chart.series);
  switch (chart.yUnit) {
    case 'bytes':
      {
        return (0, _formatters.getFixedByteFormatter)(max);
      }
    case 'percent':
      {
        return y => (0, _formatters.asPercent)(y || 0, 1);
      }
    case 'time':
      {
        const durationFormatter = (0, _formatters.getDurationFormatter)(max);
        return (0, _helper.getResponseTimeTickFormatter)(durationFormatter);
      }
    case 'integer':
      {
        return _formatters.asInteger;
      }
    default:
      {
        return _formatters.asDecimal;
      }
  }
}
function MetricsChart({
  chart,
  fetchStatus
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("span", null, chart.title))), chart.description && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: chart.description,
    position: "top",
    type: "question"
  }))), /*#__PURE__*/_react.default.createElement(_timeseries_chart_with_context.TimeseriesChartWithContext, {
    fetchStatus: fetchStatus,
    id: chart.key,
    timeseries: chart.series,
    yLabelFormat: getYTickFormatter(chart)
  }));
}