"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findInternalRulesRoute = void 0;
var _find = require("../../../../../common/routes/rule/apis/find");
var _types = require("../../../../types");
var _lib = require("../../../lib");
var _track_legacy_terminology = require("../../../lib/track_legacy_terminology");
var _transforms = require("./transforms");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findInternalRulesRoute = (router, licenseState, usageCounter) => {
  router.post({
    path: _types.INTERNAL_ALERTING_API_FIND_RULES_PATH,
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: 'internal'
    },
    validate: {
      body: _find.findRulesInternalRequestBodySchemaV1
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesClient = await (await context.alerting).getRulesClient();
    const body = req.body;
    (0, _track_legacy_terminology.trackLegacyTerminology)([req.body.search, req.body.search_fields, req.body.sort_field].filter(Boolean), usageCounter);
    const options = (0, _transforms.transformFindRulesInternalBodyV1)({
      ...body,
      has_reference: body.has_reference || undefined
    });
    if (req.body.fields) {
      usageCounter === null || usageCounter === void 0 ? void 0 : usageCounter.incrementCounter({
        counterName: `alertingFieldsUsage`,
        counterType: 'alertingFieldsUsage',
        incrementBy: 1
      });
    }
    const findResult = await rulesClient.find({
      options,
      excludeFromPublicApi: false,
      includeSnoozeData: true
    });
    const responseBody = (0, _transforms.transformFindRulesResponseV1)(findResult, options.fields, true);
    return res.ok({
      body: responseBody
    });
  })));
};
exports.findInternalRulesRoute = findInternalRulesRoute;