"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.loggerMock = void 0;
var tslib_1 = require("tslib");
var createLoggerMock = function (context) {
    if (context === void 0) { context = []; }
    var mockLog = {
        context: context,
        debug: jest.fn(),
        info: jest.fn(),
        error: jest.fn(),
        warn: jest.fn(),
        get: jest.fn(),
    };
    mockLog.get.mockImplementation(function () {
        var ctx = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            ctx[_i] = arguments[_i];
        }
        return (tslib_1.__assign(tslib_1.__assign({}, mockLog), { context: Array.isArray(context) ? context.concat(ctx) : tslib_1.__spreadArray([context], tslib_1.__read(ctx), false).filter(Boolean) }));
    });
    return mockLog;
};
var clearLoggerMock = function (logger) {
    logger.debug.mockClear();
    logger.info.mockClear();
    logger.warn.mockClear();
    logger.error.mockClear();
};
var convertMessageSource = function (value) {
    var message = typeof value[0] === 'function' ? value[0]() : value[0];
    var meta = value[1];
    if (meta) {
        return [message, meta];
    }
    else {
        return [message];
    }
};
var convertMessageSourceOrError = function (value) {
    var message = typeof value[0] === 'function' ? value[0]() : value[0];
    var meta = value[1];
    if (meta) {
        return [message, meta];
    }
    else {
        return [message];
    }
};
var collectLoggerMock = function (logger) {
    return {
        debug: logger.debug.mock.calls.map(convertMessageSource),
        info: logger.info.mock.calls.map(convertMessageSource),
        error: logger.error.mock.calls.map(convertMessageSourceOrError),
        warn: logger.warn.mock.calls.map(convertMessageSourceOrError),
    };
};
exports.loggerMock = {
    create: createLoggerMock,
    clear: clearLoggerMock,
    collect: collectLoggerMock,
};
