/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock.client;

import java.time.Clock;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.inference.common.amazon.AwsSecretSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockServiceSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.client.AmazonBedrockClient;

public abstract class AmazonBedrockBaseClient
implements AmazonBedrockClient {
    protected final Integer modelKeysAndRegionHashcode;
    protected Clock clock = Clock.systemUTC();
    protected volatile Instant expiryTimestamp;

    protected AmazonBedrockBaseClient(AmazonBedrockModel model, @Nullable TimeValue timeout) {
        Objects.requireNonNull(model);
        this.modelKeysAndRegionHashcode = AmazonBedrockBaseClient.getModelKeysAndRegionHashcode(model, timeout);
    }

    public static Integer getModelKeysAndRegionHashcode(AmazonBedrockModel model, @Nullable TimeValue timeout) {
        AwsSecretSettings secretSettings = model.getSecretSettings();
        AmazonBedrockServiceSettings serviceSettings = model.getServiceSettings();
        return Objects.hash(secretSettings.accessKey(), secretSettings.secretKey(), serviceSettings.region(), timeout);
    }

    public final void setClock(Clock clock) {
        this.clock = clock;
    }

    Instant getExpiryTimestamp() {
        return this.expiryTimestamp;
    }

    abstract void close();
}

