/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.common;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.common.Strings;

public class MapPathExtractor {
    private static final String DOLLAR = "$";
    static final Pattern DOT_FIELD_PATTERN = Pattern.compile("^\\.([^.\\[]+)(.*)");
    static final Pattern ARRAY_WILDCARD_PATTERN = Pattern.compile("^\\[\\*\\](.*)");
    public static final String UNKNOWN_FIELD_NAME = "unknown";

    public static Result extract(Map<String, Object> data, String path) {
        if (data == null || data.isEmpty() || path == null || path.trim().isEmpty()) {
            return null;
        }
        String cleanedPath = path.trim();
        if (!cleanedPath.startsWith(DOLLAR)) {
            throw new IllegalArgumentException(Strings.format((String)"Path [%s] must start with a dollar sign ($)", (Object[])new Object[]{cleanedPath}));
        }
        cleanedPath = cleanedPath.substring(DOLLAR.length());
        LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
        return new Result(MapPathExtractor.navigate(data, cleanedPath, new FieldNameInfo("", "", fieldNames)), fieldNames.stream().toList());
    }

    private static Object navigate(Object current, String remainingPath, FieldNameInfo fieldNameInfo) {
        if (current == null || Strings.isNullOrEmpty((String)remainingPath)) {
            return current;
        }
        Matcher dotFieldMatcher = DOT_FIELD_PATTERN.matcher(remainingPath);
        Matcher arrayWildcardMatcher = ARRAY_WILDCARD_PATTERN.matcher(remainingPath);
        if (dotFieldMatcher.matches()) {
            String field = dotFieldMatcher.group(1);
            if (field == null || field.isEmpty()) {
                throw new IllegalArgumentException(Strings.format((String)"Unable to extract field from remaining path [%s]. Fields must be delimited by a dot character.", (Object[])new Object[]{remainingPath}));
            }
            String nextPath = dotFieldMatcher.group(2);
            if (current instanceof Map) {
                Map currentMap = (Map)current;
                Object fieldFromMap = currentMap.get(field);
                if (fieldFromMap == null) {
                    throw new IllegalArgumentException(Strings.format((String)"Unable to find field [%s] in map", (Object[])new Object[]{field}));
                }
                if (Strings.isNullOrEmpty((String)nextPath)) {
                    fieldNameInfo.addTraversedField(field);
                }
                return MapPathExtractor.navigate(currentMap.get(field), nextPath, fieldNameInfo.descend(field));
            }
            throw new IllegalArgumentException(Strings.format((String)"Current path [%s] matched the dot field pattern but the current object is not a map, found invalid type [%s] instead.", (Object[])new Object[]{remainingPath, current.getClass().getSimpleName()}));
        }
        if (arrayWildcardMatcher.matches()) {
            String nextPath = arrayWildcardMatcher.group(1);
            if (current instanceof List) {
                List list = (List)current;
                fieldNameInfo.addCurrentField();
                ArrayList<Object> results = new ArrayList<Object>();
                for (Object item : list) {
                    Object result = MapPathExtractor.navigate(item, nextPath, fieldNameInfo);
                    if (result == null) continue;
                    results.add(result);
                }
                return results;
            }
            throw new IllegalArgumentException(Strings.format((String)"Current path [%s] matched the array field pattern but the current object is not a list, found invalid type [%s] instead.", (Object[])new Object[]{remainingPath, current.getClass().getSimpleName()}));
        }
        throw new IllegalArgumentException(Strings.format((String)"Invalid path received [%s], unable to extract a field name.", (Object[])new Object[]{remainingPath}));
    }

    public record Result(Object extractedObject, List<String> traversedFields) {
        public String getArrayFieldName(int index) {
            if (this.traversedFields.size() <= index || index < 0) {
                return MapPathExtractor.UNKNOWN_FIELD_NAME;
            }
            return this.traversedFields.get(index);
        }
    }

    private record FieldNameInfo(String currentPath, String fieldName, Set<String> traversedFields) {
        void addTraversedField(String fieldName) {
            this.traversedFields.add(this.createPath(fieldName));
        }

        void addCurrentField() {
            this.traversedFields.add(this.currentPath);
        }

        FieldNameInfo descend(String newFieldName) {
            String newLocation = this.createPath(newFieldName);
            return new FieldNameInfo(newLocation, newFieldName, this.traversedFields);
        }

        private String createPath(String newFieldName) {
            if (Strings.isNullOrEmpty((String)this.currentPath)) {
                return newFieldName;
            }
            return this.currentPath + "." + newFieldName;
        }
    }
}

