/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.util.Random;
import java.util.random.RandomGenerator;
import org.elasticsearch.xpack.profiling.action.GetStackTracesRequest;

class Resampler {
    private final boolean requiresResampling;
    private final RandomGenerator r;
    private final double adjustedSampleRate;
    public final double p;

    Resampler(GetStackTracesRequest request, double sampleRate, long totalCount) {
        if ((double)totalCount > (double)request.getSampleSize() * 1.1) {
            this.requiresResampling = true;
            this.r = this.createRandom(request);
            this.p = (double)request.getSampleSize() / (double)totalCount;
        } else {
            this.requiresResampling = false;
            this.r = null;
            this.p = 1.0;
        }
        this.adjustedSampleRate = request.isAdjustSampleCount() ? sampleRate : 1.0;
    }

    protected RandomGenerator createRandom(GetStackTracesRequest request) {
        return new Random(request.hashCode());
    }

    public int adjustSampleCount(int originalCount) {
        int rawCount;
        if (this.requiresResampling) {
            rawCount = 0;
            for (int i = 0; i < originalCount; ++i) {
                if (!(this.r.nextDouble() < this.p)) continue;
                ++rawCount;
            }
        } else {
            rawCount = originalCount;
        }
        return (int)Math.round((double)rawCount / (this.p * this.adjustedSampleRate));
    }
}

