/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich.action;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.local.TransportLocalClusterStateAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.enrich.action.EnrichStatsAction;
import org.elasticsearch.xpack.enrich.action.EnrichCoordinatorStatsAction;

public class TransportEnrichStatsAction
extends TransportLocalClusterStateAction<EnrichStatsAction.Request, EnrichStatsAction.Response> {
    private final Client client;

    @Inject
    public TransportEnrichStatsAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, Client client) {
        super("cluster:monitor/xpack/enrich/stats", actionFilters, transportService.getTaskManager(), clusterService, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
        transportService.registerRequestHandler(this.actionName, this.executor, false, true, EnrichStatsAction.Request::new, (request, channel, task) -> this.executeDirect(task, (ActionRequest)request, (ActionListener)new ChannelActionListener(channel)));
    }

    protected void localClusterStateOperation(Task task, EnrichStatsAction.Request request, ClusterState state, ActionListener<EnrichStatsAction.Response> listener) {
        EnrichCoordinatorStatsAction.Request statsRequest = new EnrichCoordinatorStatsAction.Request();
        ActionListener statsListener = listener.delegateFailureAndWrap((delegate, response) -> {
            if (response.hasFailures()) {
                FailedNodeException failure = null;
                for (FailedNodeException nodeFailure : response.failures()) {
                    if (failure == null) {
                        failure = nodeFailure;
                        continue;
                    }
                    failure.addSuppressed((Throwable)nodeFailure);
                }
                delegate.onFailure(failure);
                return;
            }
            List coordinatorStats = response.getNodes().stream().map(EnrichCoordinatorStatsAction.NodeResponse::getCoordinatorStats).sorted(Comparator.comparing(EnrichStatsAction.Response.CoordinatorStats::nodeId)).collect(Collectors.toList());
            List policyExecutionTasks = this.taskManager.getTasks().values().stream().filter(t -> t.getAction().equals("policy_execution")).map(t -> t.taskInfo(this.clusterService.localNode().getId(), true)).map(t -> new EnrichStatsAction.Response.ExecutingPolicy(t.description(), t)).sorted(Comparator.comparing(EnrichStatsAction.Response.ExecutingPolicy::name)).collect(Collectors.toList());
            List cacheStats = response.getNodes().stream().map(EnrichCoordinatorStatsAction.NodeResponse::getCacheStats).filter(Objects::nonNull).sorted(Comparator.comparing(EnrichStatsAction.Response.CacheStats::nodeId)).collect(Collectors.toList());
            delegate.onResponse((Object)new EnrichStatsAction.Response(policyExecutionTasks, coordinatorStats, cacheStats));
        });
        ((CancellableTask)task).ensureNotCancelled();
        this.client.execute((ActionType)EnrichCoordinatorStatsAction.INSTANCE, (ActionRequest)statsRequest, statsListener);
    }

    protected ClusterBlockException checkBlock(EnrichStatsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

