/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb.patternedtext;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.intervals.Intervals;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOFunction;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.elasticsearch.common.CheckedIntFunction;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.SourceValueFetcherSortedBinaryIndexFieldData;
import org.elasticsearch.index.mapper.BlockDocValuesReader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.extras.SourceConfirmedTextQuery;
import org.elasticsearch.index.mapper.extras.SourceIntervalsSource;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.field.KeywordDocValuesField;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.xpack.logsdb.patternedtext.PatternedTextFieldMapper;
import org.elasticsearch.xpack.logsdb.patternedtext.PatternedTextIndexFieldData;

public class PatternedTextFieldType
extends StringFieldType {
    private static final String TEMPLATE_SUFFIX = ".template";
    private static final String ARGS_SUFFIX = ".args";
    public static final String CONTENT_TYPE = "patterned_text";
    private final Analyzer indexAnalyzer;
    private final TextFieldMapper.TextFieldType textFieldType;

    PatternedTextFieldType(String name, TextSearchInfo tsi, Analyzer indexAnalyzer, boolean isSyntheticSource, Map<String, String> meta) {
        super(name, true, false, false, tsi, meta);
        this.indexAnalyzer = Objects.requireNonNull(indexAnalyzer);
        this.textFieldType = new TextFieldMapper.TextFieldType(name, isSyntheticSource);
    }

    PatternedTextFieldType(String name) {
        this(name, new TextSearchInfo(PatternedTextFieldMapper.Defaults.FIELD_TYPE, null, Lucene.STANDARD_ANALYZER, Lucene.STANDARD_ANALYZER), (Analyzer)Lucene.STANDARD_ANALYZER, false, Collections.emptyMap());
    }

    public String typeName() {
        return CONTENT_TYPE;
    }

    public String familyTypeName() {
        return "text";
    }

    public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
        return SourceValueFetcher.toString((String)this.name(), (SearchExecutionContext)context, (String)format);
    }

    private IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> getValueFetcherProvider(SearchExecutionContext searchExecutionContext) {
        return context -> {
            ValueFetcher valueFetcher = this.valueFetcher(searchExecutionContext, null);
            SearchLookup sourceProvider = searchExecutionContext.lookup();
            valueFetcher.setNextReader(context);
            return arg_0 -> PatternedTextFieldType.lambda$getValueFetcherProvider$0(valueFetcher, (SourceProvider)sourceProvider, context, arg_0);
        };
    }

    private Query sourceConfirmedQuery(Query query, SearchExecutionContext context) {
        return new ConstantScoreQuery((Query)new SourceConfirmedTextQuery(query, this.getValueFetcherProvider(context), this.indexAnalyzer));
    }

    private IntervalsSource toIntervalsSource(IntervalsSource source, Query approximation, SearchExecutionContext searchExecutionContext) {
        return new SourceIntervalsSource(source, approximation, this.getValueFetcherProvider(searchExecutionContext), this.indexAnalyzer);
    }

    public Query termQuery(Object query, SearchExecutionContext context) {
        return new ConstantScoreQuery(super.termQuery(query, context));
    }

    public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context, MultiTermQuery.RewriteMethod rewriteMethod) {
        return new ConstantScoreQuery(super.fuzzyQuery(value, fuzziness, prefixLength, maxExpansions, transpositions, context, rewriteMethod));
    }

    public Query existsQuery(SearchExecutionContext context) {
        return new FieldExistsQuery(this.templateFieldName());
    }

    public IntervalsSource termIntervals(BytesRef term, SearchExecutionContext context) {
        return this.toIntervalsSource(Intervals.term((BytesRef)term), (Query)new TermQuery(new Term(this.name(), term)), context);
    }

    public IntervalsSource prefixIntervals(BytesRef term, SearchExecutionContext context) {
        return this.toIntervalsSource(Intervals.prefix((BytesRef)term, (int)IndexSearcher.getMaxClauseCount()), (Query)new PrefixQuery(new Term(this.name(), term)), context);
    }

    public IntervalsSource fuzzyIntervals(String term, int maxDistance, int prefixLength, boolean transpositions, SearchExecutionContext context) {
        FuzzyQuery fuzzyQuery = new FuzzyQuery(new Term(this.name(), term), maxDistance, prefixLength, IndexSearcher.getMaxClauseCount(), transpositions, MultiTermQuery.CONSTANT_SCORE_BLENDED_REWRITE);
        IntervalsSource fuzzyIntervals = Intervals.multiterm((CompiledAutomaton)fuzzyQuery.getAutomata(), (int)IndexSearcher.getMaxClauseCount(), (String)term);
        return this.toIntervalsSource(fuzzyIntervals, (Query)fuzzyQuery, context);
    }

    public IntervalsSource wildcardIntervals(BytesRef pattern, SearchExecutionContext context) {
        return this.toIntervalsSource(Intervals.wildcard((BytesRef)pattern, (int)IndexSearcher.getMaxClauseCount()), (Query)new MatchAllDocsQuery(), context);
    }

    public IntervalsSource regexpIntervals(BytesRef pattern, SearchExecutionContext context) {
        return this.toIntervalsSource(Intervals.regexp((BytesRef)pattern, (int)IndexSearcher.getMaxClauseCount()), (Query)new MatchAllDocsQuery(), context);
    }

    public IntervalsSource rangeIntervals(BytesRef lowerTerm, BytesRef upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
        return this.toIntervalsSource(Intervals.range((BytesRef)lowerTerm, (BytesRef)upperTerm, (boolean)includeLower, (boolean)includeUpper, (int)IndexSearcher.getMaxClauseCount()), (Query)new MatchAllDocsQuery(), context);
    }

    public Query phraseQuery(TokenStream stream, int slop, boolean enablePosIncrements, SearchExecutionContext queryShardContext) throws IOException {
        Query textQuery = this.textFieldType.phraseQuery(stream, slop, enablePosIncrements, queryShardContext);
        return this.sourceConfirmedQuery(textQuery, queryShardContext);
    }

    public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, SearchExecutionContext queryShardContext) throws IOException {
        Query textQuery = this.textFieldType.multiPhraseQuery(stream, slop, enablePositionIncrements, queryShardContext);
        return this.sourceConfirmedQuery(textQuery, queryShardContext);
    }

    public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions, SearchExecutionContext queryShardContext) throws IOException {
        Query textQuery = this.textFieldType.phrasePrefixQuery(stream, slop, maxExpansions, queryShardContext);
        return this.sourceConfirmedQuery(textQuery, queryShardContext);
    }

    public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
        return new BlockDocValuesReader.BytesRefsFromBinaryBlockLoader(this.name());
    }

    public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
        if (fieldDataContext.fielddataOperation() != MappedFieldType.FielddataOperation.SCRIPT) {
            throw new IllegalArgumentException("patterned_text fields do not support sorting and aggregations");
        }
        if (this.textFieldType.isSyntheticSource()) {
            return new PatternedTextIndexFieldData.Builder(this);
        }
        return new SourceValueFetcherSortedBinaryIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.KEYWORD, (ValueFetcher)SourceValueFetcher.toString((Set)((Set)fieldDataContext.sourcePathsLookup().apply(this.name()))), (SourceProvider)fieldDataContext.lookupSupplier().get(), KeywordDocValuesField::new);
    }

    String templateFieldName() {
        return this.name() + TEMPLATE_SUFFIX;
    }

    String argsFieldName() {
        return this.name() + ARGS_SUFFIX;
    }

    private static /* synthetic */ List lambda$getValueFetcherProvider$0(ValueFetcher valueFetcher, SourceProvider sourceProvider, LeafReaderContext context, int docID) throws IOException {
        try {
            return valueFetcher.fetchValues(sourceProvider.getSource(context, docID), docID, new ArrayList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

