/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.session;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFailure;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverCompletionInfo;
import org.elasticsearch.compute.operator.FailureCollector;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesExpressionGrouper;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.action.EsqlExecutionInfo;
import org.elasticsearch.xpack.esql.action.EsqlQueryRequest;
import org.elasticsearch.xpack.esql.analysis.Analyzer;
import org.elasticsearch.xpack.esql.analysis.AnalyzerContext;
import org.elasticsearch.xpack.esql.analysis.EnrichResolution;
import org.elasticsearch.xpack.esql.analysis.PreAnalyzer;
import org.elasticsearch.xpack.esql.analysis.Verifier;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.EmptyAttribute;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedStar;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.enrich.EnrichPolicyResolver;
import org.elasticsearch.xpack.esql.enrich.ResolvedEnrichPolicy;
import org.elasticsearch.xpack.esql.expression.UnresolvedNamePattern;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.esql.index.EsIndex;
import org.elasticsearch.xpack.esql.index.IndexResolution;
import org.elasticsearch.xpack.esql.index.MappingException;
import org.elasticsearch.xpack.esql.inference.InferenceResolution;
import org.elasticsearch.xpack.esql.inference.InferenceRunner;
import org.elasticsearch.xpack.esql.optimizer.LogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalPlanOptimizer;
import org.elasticsearch.xpack.esql.parser.EsqlParser;
import org.elasticsearch.xpack.esql.parser.QueryParams;
import org.elasticsearch.xpack.esql.plan.IndexPattern;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Drop;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Explain;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.Fork;
import org.elasticsearch.xpack.esql.plan.logical.InlineStats;
import org.elasticsearch.xpack.esql.plan.logical.Insist;
import org.elasticsearch.xpack.esql.plan.logical.Keep;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;
import org.elasticsearch.xpack.esql.plan.logical.Rename;
import org.elasticsearch.xpack.esql.plan.logical.TopN;
import org.elasticsearch.xpack.esql.plan.logical.UnresolvedRelation;
import org.elasticsearch.xpack.esql.plan.logical.inference.Completion;
import org.elasticsearch.xpack.esql.plan.logical.inference.InferencePlan;
import org.elasticsearch.xpack.esql.plan.logical.join.InlineJoin;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinType;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinTypes;
import org.elasticsearch.xpack.esql.plan.logical.join.LookupJoin;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.LocalSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.planner.mapper.Mapper;
import org.elasticsearch.xpack.esql.planner.premapper.PreMapper;
import org.elasticsearch.xpack.esql.plugin.TransportActionServices;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.esql.session.EsqlCCSUtils;
import org.elasticsearch.xpack.esql.session.IndexResolver;
import org.elasticsearch.xpack.esql.session.NoClustersToSearchException;
import org.elasticsearch.xpack.esql.session.Result;
import org.elasticsearch.xpack.esql.session.SessionUtils;
import org.elasticsearch.xpack.esql.telemetry.PlanTelemetry;

public class EsqlSession {
    private static final Logger LOGGER = LogManager.getLogger(EsqlSession.class);
    private final String sessionId;
    private final Configuration configuration;
    private final IndexResolver indexResolver;
    private final EnrichPolicyResolver enrichPolicyResolver;
    private final PreAnalyzer preAnalyzer;
    private final Verifier verifier;
    private final EsqlFunctionRegistry functionRegistry;
    private final LogicalPlanOptimizer logicalPlanOptimizer;
    private final PreMapper preMapper;
    private final Mapper mapper;
    private final PhysicalPlanOptimizer physicalPlanOptimizer;
    private final PlanTelemetry planTelemetry;
    private final IndicesExpressionGrouper indicesExpressionGrouper;
    private Set<String> configuredClusters;
    private final InferenceRunner inferenceRunner;
    private boolean explainMode;
    private String parsedPlanString;
    private String optimizedLogicalPlanString;

    public EsqlSession(String sessionId, Configuration configuration, IndexResolver indexResolver, EnrichPolicyResolver enrichPolicyResolver, PreAnalyzer preAnalyzer, EsqlFunctionRegistry functionRegistry, LogicalPlanOptimizer logicalPlanOptimizer, Mapper mapper, Verifier verifier, PlanTelemetry planTelemetry, IndicesExpressionGrouper indicesExpressionGrouper, TransportActionServices services) {
        this.sessionId = sessionId;
        this.configuration = configuration;
        this.indexResolver = indexResolver;
        this.enrichPolicyResolver = enrichPolicyResolver;
        this.preAnalyzer = preAnalyzer;
        this.verifier = verifier;
        this.functionRegistry = functionRegistry;
        this.mapper = mapper;
        this.logicalPlanOptimizer = logicalPlanOptimizer;
        this.physicalPlanOptimizer = new PhysicalPlanOptimizer(new PhysicalOptimizerContext(configuration));
        this.planTelemetry = planTelemetry;
        this.indicesExpressionGrouper = indicesExpressionGrouper;
        this.inferenceRunner = services.inferenceRunner();
        this.preMapper = new PreMapper(services);
    }

    public String sessionId() {
        return this.sessionId;
    }

    public void execute(final EsqlQueryRequest request, final EsqlExecutionInfo executionInfo, final PlanRunner planRunner, final ActionListener<Result> listener) {
        assert (executionInfo != null) : "Null EsqlExecutionInfo";
        LOGGER.debug("ESQL query:\n{}", new Object[]{request.query()});
        LogicalPlan parsed = this.parse(request.query(), request.params());
        if (parsed instanceof Explain) {
            Explain explain = (Explain)parsed;
            this.explainMode = true;
            parsed = explain.query();
            this.parsedPlanString = parsed.toString();
        }
        this.analyzedPlan(parsed, executionInfo, request.filter(), new EsqlCCSUtils.CssPartialErrorsActionListener(executionInfo, listener){

            public void onResponse(LogicalPlan analyzedPlan) {
                EsqlSession.this.preMapper.preMapper(analyzedPlan, (ActionListener<LogicalPlan>)listener.delegateFailureAndWrap((l, p) -> EsqlSession.this.executeOptimizedPlan(request, executionInfo, planRunner, EsqlSession.this.optimizedPlan((LogicalPlan)((Object)p)), (ActionListener<Result>)l)));
            }
        });
    }

    public void executeOptimizedPlan(EsqlQueryRequest request, EsqlExecutionInfo executionInfo, PlanRunner planRunner, LogicalPlan optimizedPlan, ActionListener<Result> listener) {
        PhysicalPlan physicalPlan = this.logicalPlanToPhysicalPlan(optimizedPlan, request);
        if (this.explainMode) {
            String physicalPlanString = physicalPlan.toString();
            List<ReferenceAttribute> fields = List.of(new ReferenceAttribute(Source.EMPTY, "role", DataType.KEYWORD), new ReferenceAttribute(Source.EMPTY, "type", DataType.KEYWORD), new ReferenceAttribute(Source.EMPTY, "plan", DataType.KEYWORD));
            ArrayList<List<String>> values = new ArrayList<List<String>>();
            values.add(List.of("coordinator", "parsedPlan", this.parsedPlanString));
            values.add(List.of("coordinator", "optimizedLogicalPlan", this.optimizedLogicalPlanString));
            values.add(List.of("coordinator", "optimizedPhysicalPlan", physicalPlanString));
            Block[] blocks = BlockUtils.fromList((BlockFactory)PlannerUtils.NON_BREAKING_BLOCK_FACTORY, values);
            physicalPlan = new LocalSourceExec(Source.EMPTY, fields, LocalSupplier.of(blocks));
        }
        EsqlCCSUtils.updateExecutionInfoAtEndOfPlanning(executionInfo);
        this.executeSubPlans(physicalPlan, planRunner, executionInfo, request, listener);
    }

    private void executeSubPlans(PhysicalPlan physicalPlan, PlanRunner runner, EsqlExecutionInfo executionInfo, EsqlQueryRequest request, ActionListener<Result> listener) {
        ArrayList subplans = new ArrayList();
        physicalPlan.forEachUp(FragmentExec.class, f -> f.fragment().forEachUp(InlineJoin.class, ij -> {
            LogicalPlan subplan = InlineJoin.replaceStub(ij.left(), ij.right());
            subplan.setOptimized();
            PhysicalPlan subqueryPlan = this.logicalPlanToPhysicalPlan(subplan, request);
            subplans.add(new PlanTuple(subqueryPlan, ij.right()));
        }));
        Iterator<PlanTuple> iterator = subplans.iterator();
        if (subplans.size() > 0) {
            this.executeSubPlan(new DriverCompletionInfo.Accumulator(), physicalPlan, iterator, executionInfo, runner, listener);
        } else {
            runner.run(physicalPlan, listener);
        }
    }

    private void executeSubPlan(DriverCompletionInfo.Accumulator completionInfoAccumulator, PhysicalPlan plan, Iterator<PlanTuple> subPlanIterator, EsqlExecutionInfo executionInfo, PlanRunner runner, ActionListener<Result> listener) {
        PlanTuple tuple = subPlanIterator.next();
        runner.run(tuple.physical, (ActionListener<Result>)listener.delegateFailureAndWrap((next, result) -> {
            try {
                completionInfoAccumulator.accumulate(result.completionInfo());
                LocalRelation resultWrapper = this.resultToPlan(tuple.logical, (Result)result);
                PhysicalPlan newPlan = (PhysicalPlan)plan.transformUp(FragmentExec.class, f -> {
                    LogicalPlan frag = f.fragment();
                    return f.withFragment((LogicalPlan)frag.transformUp(InlineJoin.class, ij -> ij.right() == tuple.logical ? InlineJoin.inlineData(ij, resultWrapper) : ij));
                });
                if (!subPlanIterator.hasNext()) {
                    runner.run(newPlan, (ActionListener<Result>)next.delegateFailureAndWrap((finalListener, finalResult) -> {
                        completionInfoAccumulator.accumulate(finalResult.completionInfo());
                        finalListener.onResponse((Object)new Result(finalResult.schema(), finalResult.pages(), completionInfoAccumulator.finish(), executionInfo));
                    }));
                } else {
                    this.executeSubPlan(completionInfoAccumulator, newPlan, subPlanIterator, executionInfo, runner, (ActionListener<Result>)next);
                }
            }
            finally {
                Releasables.closeExpectNoException((Releasable)Releasables.wrap((Iterator)Iterators.map(result.pages().iterator(), p -> () -> ((Page)p).releaseBlocks())));
            }
        }));
    }

    private LocalRelation resultToPlan(LogicalPlan plan, Result result) {
        List<Page> pages = result.pages();
        List<Attribute> schema = result.schema();
        Block[] blocks = SessionUtils.fromPages(schema, pages);
        return new LocalRelation(plan.source(), schema, LocalSupplier.of(blocks));
    }

    private LogicalPlan parse(String query, QueryParams params) {
        LogicalPlan parsed = new EsqlParser().createStatement(query, params, this.planTelemetry, this.configuration);
        LOGGER.debug("Parsed logical plan:\n{}", new Object[]{parsed});
        return parsed;
    }

    static void handleFieldCapsFailures(boolean allowPartialResults, EsqlExecutionInfo executionInfo, Map<String, List<FieldCapabilitiesFailure>> failures) throws Exception {
        FailureCollector failureCollector = new FailureCollector();
        for (Map.Entry<String, List<FieldCapabilitiesFailure>> e : failures.entrySet()) {
            String clusterAlias = e.getKey();
            EsqlExecutionInfo.Cluster cluster = executionInfo.getCluster(clusterAlias);
            if (cluster.getStatus() != EsqlExecutionInfo.Cluster.Status.RUNNING) {
                assert (cluster.getStatus() != EsqlExecutionInfo.Cluster.Status.SUCCESSFUL) : "can't mark a cluster success with failures";
                continue;
            }
            if (!allowPartialResults && !executionInfo.isSkipUnavailable(clusterAlias)) {
                for (FieldCapabilitiesFailure failure : e.getValue()) {
                    failureCollector.unwrapAndCollect(failure.getException());
                }
                continue;
            }
            if (!cluster.getFailures().isEmpty()) continue;
            List<ShardSearchFailure> shardFailures = e.getValue().stream().map(f -> {
                ShardId shardId = null;
                Throwable patt0$temp = ExceptionsHelper.unwrapCause((Throwable)f.getException());
                if (patt0$temp instanceof ElasticsearchException) {
                    ElasticsearchException es = (ElasticsearchException)patt0$temp;
                    shardId = es.getShardId();
                }
                if (shardId != null) {
                    return new ShardSearchFailure(f.getException(), new SearchShardTarget(null, shardId, clusterAlias));
                }
                return new ShardSearchFailure(f.getException());
            }).toList();
            executionInfo.swapCluster(clusterAlias, (k, curr) -> new EsqlExecutionInfo.Cluster.Builder(cluster).addFailures(shardFailures).build());
        }
        Exception failure = failureCollector.getFailure();
        if (failure != null) {
            throw failure;
        }
    }

    public void analyzedPlan(LogicalPlan parsed, EsqlExecutionInfo executionInfo, QueryBuilder requestFilter, ActionListener<LogicalPlan> logicalPlanListener) {
        if (parsed.analyzed()) {
            logicalPlanListener.onResponse((Object)parsed);
            return;
        }
        CheckedFunction analyzeAction = l -> {
            EsqlSession.handleFieldCapsFailures(this.configuration.allowPartialResults(), executionInfo, l.indices.failures());
            Analyzer analyzer = new Analyzer(new AnalyzerContext(this.configuration, this.functionRegistry, l.indices, l.lookupIndices, l.enrichResolution, l.inferenceResolution), this.verifier);
            LogicalPlan plan = analyzer.analyze(parsed);
            plan.setAnalyzed();
            return plan;
        };
        this.configuredClusters = Set.copyOf(this.indicesExpressionGrouper.getConfiguredClusters());
        PreAnalyzer.PreAnalysis preAnalysis = this.preAnalyzer.preAnalyze(parsed);
        Set unresolvedPolicies = preAnalysis.enriches.stream().map(e -> new EnrichPolicyResolver.UnresolvedPolicy(BytesRefs.toString((Object)e.policyName().fold(FoldContext.small())), e.mode())).collect(Collectors.toSet());
        List<IndexPattern> indices = preAnalysis.indices;
        EsqlCCSUtils.checkForCcsLicense(executionInfo, indices, this.indicesExpressionGrouper, this.configuredClusters, this.verifier.licenseState());
        this.initializeClusterData(indices, executionInfo);
        SubscribableListener listener = SubscribableListener.newForked(l -> this.enrichPolicyResolver.resolvePolicies(unresolvedPolicies, executionInfo, (ActionListener<EnrichResolution>)l)).andThen((l, enrichResolution) -> EsqlSession.resolveFieldNames(parsed, enrichResolution, (ActionListener<PreAnalysisResult>)l)).andThen((l, preAnalysisResult) -> this.resolveInferences(preAnalysis.inferencePlans, (PreAnalysisResult)preAnalysisResult, (ActionListener<PreAnalysisResult>)l));
        for (IndexPattern index : preAnalysis.lookupIndices) {
            listener = listener.andThen((l, preAnalysisResult) -> this.preAnalyzeLookupIndex(index, (PreAnalysisResult)preAnalysisResult, (ActionListener<PreAnalysisResult>)l));
        }
        listener.andThen((l, result) -> this.preAnalyzeMainIndices(preAnalysis, executionInfo, (PreAnalysisResult)result, requestFilter, (ActionListener<PreAnalysisResult>)l)).andThen((l, result) -> {
            if (result.indices.isValid() && this.allCCSClustersSkipped(executionInfo, (PreAnalysisResult)result, logicalPlanListener)) {
                return;
            }
            l.onResponse(result);
        }).andThen((l, result) -> EsqlSession.analyzeAndMaybeRetry((CheckedFunction<PreAnalysisResult, LogicalPlan, Exception>)analyzeAction, requestFilter, result, executionInfo, logicalPlanListener, (ActionListener<PreAnalysisResult>)l)).andThen((l, result) -> {
            assert (requestFilter != null) : "The second pre-analysis shouldn't take place when there is no index filter in the request";
            this.preAnalyzeMainIndices(preAnalysis, executionInfo, (PreAnalysisResult)result, null, (ActionListener<PreAnalysisResult>)l);
        }).andThen((l, result) -> {
            LogicalPlan plan;
            assert (requestFilter != null) : "The second analysis shouldn't take place when there is no index filter in the request";
            LOGGER.debug("Analyzing the plan (second attempt, without filter)");
            try {
                EsqlCCSUtils.updateExecutionInfoWithUnavailableClusters(executionInfo, result.indices.failures());
                EsqlCCSUtils.updateExecutionInfoWithClustersWithNoMatchingIndices(executionInfo, result.indices, false);
                plan = (LogicalPlan)((Object)((Object)analyzeAction.apply(result)));
            }
            catch (Exception e) {
                l.onFailure(e);
                return;
            }
            LOGGER.debug("Analyzed plan (second attempt, without filter):\n{}", new Object[]{plan});
            l.onResponse((Object)plan);
        }).addListener(logicalPlanListener);
    }

    private void preAnalyzeLookupIndex(IndexPattern table, PreAnalysisResult result, ActionListener<PreAnalysisResult> listener) {
        Set<String> fieldNames = result.wildcardJoinIndices().contains(table.indexPattern()) ? IndexResolver.ALL_FIELDS : result.fieldNames;
        this.indexResolver.resolveAsMergedMapping(table.indexPattern(), fieldNames, null, (ActionListener<IndexResolution>)listener.map(indexResolution -> result.addLookupIndexResolution(table.indexPattern(), (IndexResolution)indexResolution)));
    }

    private void initializeClusterData(List<IndexPattern> indices, EsqlExecutionInfo executionInfo) {
        if (indices.isEmpty()) {
            return;
        }
        assert (indices.size() == 1) : "Only single index pattern is supported";
        Map clusterIndices = this.indicesExpressionGrouper.groupIndices(this.configuredClusters, IndicesOptions.DEFAULT, indices.getFirst().indexPattern());
        for (Map.Entry entry : clusterIndices.entrySet()) {
            String clusterAlias = (String)entry.getKey();
            String indexExpr = Strings.arrayToCommaDelimitedString((Object[])((OriginalIndices)entry.getValue()).indices());
            executionInfo.swapCluster(clusterAlias, (k, v) -> {
                assert (v == null) : "No cluster for " + clusterAlias + " should have been added to ExecutionInfo yet";
                return new EsqlExecutionInfo.Cluster(clusterAlias, indexExpr, executionInfo.isSkipUnavailable(clusterAlias));
            });
        }
    }

    private void preAnalyzeMainIndices(PreAnalyzer.PreAnalysis preAnalysis, EsqlExecutionInfo executionInfo, PreAnalysisResult result, QueryBuilder requestFilter, ActionListener<PreAnalysisResult> listener) {
        List<IndexPattern> indices = preAnalysis.indices;
        if (indices.size() > 1) {
            listener.onFailure((Exception)((Object)new MappingException("Queries with multiple indices are not supported", new Object[0])));
        } else if (indices.size() == 1) {
            IndexPattern table = indices.getFirst();
            String indexExpressionToResolve = EsqlCCSUtils.createIndexExpressionFromAvailableClusters(executionInfo);
            if (indexExpressionToResolve.isEmpty()) {
                listener.onResponse((Object)result.withIndexResolution(IndexResolution.valid(new EsIndex(table.indexPattern(), Map.of(), Map.of()))));
            } else {
                if (preAnalysis.indexMode == IndexMode.TIME_SERIES) {
                    TermQueryBuilder indexModeFilter = new TermQueryBuilder("_index_mode", IndexMode.TIME_SERIES.getName());
                    requestFilter = requestFilter != null ? new BoolQueryBuilder().filter(requestFilter).filter((QueryBuilder)indexModeFilter) : indexModeFilter;
                }
                this.indexResolver.resolveAsMergedMapping(indexExpressionToResolve, result.fieldNames, (QueryBuilder)requestFilter, (ActionListener<IndexResolution>)listener.delegateFailure((l, indexResolution) -> l.onResponse((Object)result.withIndexResolution((IndexResolution)indexResolution))));
            }
        } else {
            try {
                listener.onResponse((Object)result.withIndexResolution(IndexResolution.invalid("[none specified]")));
            }
            catch (Exception ex) {
                listener.onFailure(ex);
            }
        }
    }

    private boolean allCCSClustersSkipped(EsqlExecutionInfo executionInfo, PreAnalysisResult result, ActionListener<LogicalPlan> logicalPlanListener) {
        IndexResolution indexResolution = result.indices;
        EsqlCCSUtils.updateExecutionInfoWithUnavailableClusters(executionInfo, indexResolution.failures());
        if (executionInfo.isCrossClusterSearch() && executionInfo.getClusterStates(EsqlExecutionInfo.Cluster.Status.RUNNING).findAny().isEmpty()) {
            LOGGER.debug("No more clusters to search, ending analysis stage");
            logicalPlanListener.onFailure((Exception)new NoClustersToSearchException());
            return true;
        }
        return false;
    }

    private static void analyzeAndMaybeRetry(CheckedFunction<PreAnalysisResult, LogicalPlan, Exception> analyzeAction, QueryBuilder requestFilter, PreAnalysisResult result, EsqlExecutionInfo executionInfo, ActionListener<LogicalPlan> logicalPlanListener, ActionListener<PreAnalysisResult> l) {
        LogicalPlan plan = null;
        String filterPresentMessage = requestFilter == null ? "without" : "with";
        String attemptMessage = requestFilter == null ? "the only" : "first";
        LOGGER.debug("Analyzing the plan ({} attempt, {} filter)", new Object[]{attemptMessage, filterPresentMessage});
        try {
            if (result.indices.isValid() || requestFilter != null) {
                EsqlCCSUtils.updateExecutionInfoWithClustersWithNoMatchingIndices(executionInfo, result.indices, requestFilter != null);
            }
            plan = (LogicalPlan)((Object)analyzeAction.apply((Object)result));
        }
        catch (Exception e) {
            if (e instanceof VerificationException) {
                VerificationException ve = (VerificationException)((Object)e);
                LOGGER.debug("Analyzing the plan ({} attempt, {} filter) failed with {}", new Object[]{attemptMessage, filterPresentMessage, ve.getDetailedMessage()});
                if (requestFilter == null) {
                    logicalPlanListener.onFailure((Exception)((Object)ve));
                } else {
                    l.onResponse((Object)result);
                }
            } else {
                logicalPlanListener.onFailure(e);
            }
            return;
        }
        LOGGER.debug("Analyzed plan ({} attempt, {} filter):\n{}", new Object[]{attemptMessage, filterPresentMessage, plan});
        logicalPlanListener.onResponse((Object)plan);
    }

    private static void resolveFieldNames(LogicalPlan parsed, EnrichResolution enrichResolution, ActionListener<PreAnalysisResult> l) {
        try {
            Set<String> enrichMatchFields = enrichResolution.resolvedEnrichPolicies().stream().map(ResolvedEnrichPolicy::matchField).collect(Collectors.toSet());
            l.onResponse((Object)EsqlSession.fieldNames(parsed, enrichMatchFields, new PreAnalysisResult(enrichResolution)));
        }
        catch (Exception ex) {
            l.onFailure(ex);
        }
    }

    private void resolveInferences(List<InferencePlan<?>> inferencePlans, PreAnalysisResult preAnalysisResult, ActionListener<PreAnalysisResult> l) {
        this.inferenceRunner.resolveInferenceIds(inferencePlans, (ActionListener<InferenceResolution>)l.map(preAnalysisResult::withInferenceResolution));
    }

    static PreAnalysisResult fieldNames(LogicalPlan parsed, Set<String> enrichPolicyMatchFields, PreAnalysisResult result) {
        List inlinestats = parsed.collect(InlineStats.class::isInstance);
        HashSet<Aggregate> inlinestatsAggs = new HashSet<Aggregate>();
        for (LogicalPlan i : inlinestats) {
            inlinestatsAggs.add(((InlineStats)i).aggregate());
        }
        if (!parsed.anyMatch(p -> EsqlSession.shouldCollectReferencedFields(p, inlinestatsAggs))) {
            return result.withFieldNames(IndexResolver.ALL_FIELDS);
        }
        if (parsed.anyMatch(p -> p instanceof Fork)) {
            return result.withFieldNames(IndexResolver.ALL_FIELDS);
        }
        Holder projectAll = new Holder((Object)false);
        parsed.forEachExpressionDown(UnresolvedStar.class, us -> {
            if (((Boolean)projectAll.get()).booleanValue()) {
                return;
            }
            projectAll.set((Object)true);
        });
        if (((Boolean)projectAll.get()).booleanValue()) {
            return result.withFieldNames(IndexResolver.ALL_FIELDS);
        }
        AttributeSet.Builder referencesBuilder = AttributeSet.builder();
        AttributeSet.Builder keepRefs = AttributeSet.builder();
        AttributeSet.Builder dropWildcardRefs = AttributeSet.builder();
        AttributeSet.Builder joinRefs = AttributeSet.builder();
        HashSet<String> wildcardJoinIndices = new HashSet<String>();
        boolean[] canRemoveAliases = new boolean[]{true};
        parsed.forEachDown(p -> {
            if (p instanceof RegexExtract) {
                RegexExtract re = (RegexExtract)p;
                referencesBuilder.addAll(re.input().references());
            } else if (p instanceof Enrich) {
                Enrich enrich = (Enrich)p;
                AttributeSet enrichFieldRefs = Expressions.references(enrich.enrichFields());
                AttributeSet.Builder enrichRefs = enrichFieldRefs.combine(enrich.matchField().references()).asBuilder();
                enrichRefs.removeIf(attr -> attr instanceof EmptyAttribute);
                referencesBuilder.addAll(enrichRefs);
            } else if (p instanceof LookupJoin) {
                LookupJoin join = (LookupJoin)p;
                JoinType patt0$temp = join.config().type();
                if (patt0$temp instanceof JoinTypes.UsingJoinType) {
                    JoinTypes.UsingJoinType usingJoinType = (JoinTypes.UsingJoinType)patt0$temp;
                    joinRefs.addAll(usingJoinType.columns());
                }
                if (keepRefs.isEmpty()) {
                    wildcardJoinIndices.add(((UnresolvedRelation)join.right()).indexPattern().indexPattern());
                } else {
                    joinRefs.addAll(keepRefs);
                }
            } else {
                UnresolvedRelation ur;
                referencesBuilder.addAll(p.references());
                if (p instanceof UnresolvedRelation && (ur = (UnresolvedRelation)p).indexMode() == IndexMode.TIME_SERIES) {
                    referencesBuilder.add((Attribute)new UnresolvedAttribute(ur.source(), "@timestamp"));
                }
                p.forEachExpression(UnresolvedNamePattern.class, up -> {
                    UnresolvedAttribute ua = new UnresolvedAttribute(up.source(), up.name());
                    referencesBuilder.add((Attribute)ua);
                    if (p instanceof Keep) {
                        keepRefs.add((Attribute)ua);
                    } else if (p instanceof Drop) {
                        dropWildcardRefs.add((Attribute)ua);
                    } else {
                        throw new IllegalStateException("Only KEEP and DROP should allow wildcards");
                    }
                });
                if (p instanceof Keep) {
                    keepRefs.addAll(p.references());
                }
            }
            if (canRemoveAliases[0] && p.anyMatch(EsqlSession::couldOverrideAliases)) {
                canRemoveAliases[0] = false;
            }
            if (canRemoveAliases[0]) {
                AttributeSet planRefs = p.references();
                Set fieldNames = planRefs.names();
                p.forEachExpressionDown(NamedExpression.class, ne -> {
                    if (!(ne instanceof Alias || ne instanceof ReferenceAttribute)) {
                        return;
                    }
                    if (fieldNames.contains(ne.name())) {
                        return;
                    }
                    referencesBuilder.removeIf(attr -> EsqlSession.matchByName(attr, ne.name(), keepRefs.contains(attr) || dropWildcardRefs.contains(attr)));
                });
            }
        });
        referencesBuilder.addAll(joinRefs);
        if (!wildcardJoinIndices.isEmpty()) {
            result = result.withWildcardJoinIndices(wildcardJoinIndices);
        }
        referencesBuilder.removeIf(a -> a instanceof MetadataAttribute || MetadataAttribute.isSupported((String)a.name()));
        Set fieldNames = referencesBuilder.build().names();
        if (fieldNames.isEmpty() && enrichPolicyMatchFields.isEmpty()) {
            return result.withFieldNames(IndexResolver.INDEX_METADATA_FIELD);
        }
        fieldNames.addAll(EsqlSession.subfields(fieldNames));
        fieldNames.addAll(enrichPolicyMatchFields);
        fieldNames.addAll(EsqlSession.subfields(enrichPolicyMatchFields));
        return result.withFieldNames(fieldNames);
    }

    private static boolean shouldCollectReferencedFields(LogicalPlan plan, Set<Aggregate> inlinestatsAggs) {
        Aggregate agg;
        return plan instanceof Project || plan instanceof Aggregate && !inlinestatsAggs.contains(agg = (Aggregate)plan);
    }

    private static boolean couldOverrideAliases(LogicalPlan p) {
        return !(p instanceof Aggregate || p instanceof Completion || p instanceof Drop || p instanceof Eval || p instanceof Filter || p instanceof Fork || p instanceof InlineStats || p instanceof Insist || p instanceof Keep || p instanceof Limit || p instanceof MvExpand || p instanceof OrderBy || p instanceof Project || p instanceof RegexExtract || p instanceof Rename || p instanceof TopN || p instanceof UnresolvedRelation);
    }

    private static boolean matchByName(Attribute attr, String other, boolean skipIfPattern) {
        boolean isPattern = Regex.isSimpleMatchPattern((String)attr.name());
        if (skipIfPattern && isPattern) {
            return false;
        }
        String name = attr.name();
        return isPattern ? Regex.simpleMatch((String)name, (String)other) : name.equals(other);
    }

    private static Set<String> subfields(Set<String> names) {
        return names.stream().filter(name -> !name.endsWith("*")).map(name -> name + ".*").collect(Collectors.toSet());
    }

    private PhysicalPlan logicalPlanToPhysicalPlan(LogicalPlan optimizedPlan, EsqlQueryRequest request) {
        PhysicalPlan physicalPlan = this.optimizedPhysicalPlan(optimizedPlan);
        physicalPlan = (PhysicalPlan)physicalPlan.transformUp(FragmentExec.class, f -> {
            QueryBuilder filter = request.filter();
            if (filter != null) {
                QueryBuilder fragmentFilter = f.esFilter();
                filter = fragmentFilter != null ? QueryBuilders.boolQuery().filter(fragmentFilter).must(filter) : filter;
                LOGGER.debug("Fold filter {} to EsQueryExec", new Object[]{filter});
                f = f.withFilter(filter);
            }
            return f;
        });
        return EstimatesRowSize.estimateRowSize(0, physicalPlan);
    }

    public LogicalPlan optimizedPlan(LogicalPlan logicalPlan) {
        if (!logicalPlan.analyzed()) {
            throw new IllegalStateException("Expected analyzed plan");
        }
        LogicalPlan plan = this.logicalPlanOptimizer.optimize(logicalPlan);
        LOGGER.debug("Optimized logicalPlan plan:\n{}", new Object[]{plan});
        return plan;
    }

    public PhysicalPlan physicalPlan(LogicalPlan optimizedPlan) {
        if (!optimizedPlan.optimized()) {
            throw new IllegalStateException("Expected optimized plan");
        }
        this.optimizedLogicalPlanString = optimizedPlan.toString();
        PhysicalPlan plan = this.mapper.map(optimizedPlan);
        LOGGER.debug("Physical plan:\n{}", new Object[]{plan});
        return plan;
    }

    public PhysicalPlan optimizedPhysicalPlan(LogicalPlan optimizedPlan) {
        PhysicalPlan plan = this.physicalPlanOptimizer.optimize(this.physicalPlan(optimizedPlan));
        LOGGER.debug("Optimized physical plan:\n{}", new Object[]{plan});
        return plan;
    }

    public static interface PlanRunner {
        public void run(PhysicalPlan var1, ActionListener<Result> var2);
    }

    private record PlanTuple(PhysicalPlan physical, LogicalPlan logical) {
    }

    record PreAnalysisResult(IndexResolution indices, Map<String, IndexResolution> lookupIndices, EnrichResolution enrichResolution, Set<String> fieldNames, Set<String> wildcardJoinIndices, InferenceResolution inferenceResolution) {
        PreAnalysisResult(EnrichResolution newEnrichResolution) {
            this(null, new HashMap<String, IndexResolution>(), newEnrichResolution, Set.of(), Set.of(), InferenceResolution.EMPTY);
        }

        PreAnalysisResult withEnrichResolution(EnrichResolution newEnrichResolution) {
            return new PreAnalysisResult(this.indices(), this.lookupIndices(), newEnrichResolution, this.fieldNames(), this.wildcardJoinIndices(), this.inferenceResolution());
        }

        PreAnalysisResult withInferenceResolution(InferenceResolution newInferenceResolution) {
            return new PreAnalysisResult(this.indices(), this.lookupIndices(), this.enrichResolution(), this.fieldNames(), this.wildcardJoinIndices(), newInferenceResolution);
        }

        PreAnalysisResult withIndexResolution(IndexResolution newIndexResolution) {
            return new PreAnalysisResult(newIndexResolution, this.lookupIndices(), this.enrichResolution(), this.fieldNames(), this.wildcardJoinIndices(), this.inferenceResolution());
        }

        PreAnalysisResult addLookupIndexResolution(String index, IndexResolution newIndexResolution) {
            this.lookupIndices.put(index, newIndexResolution);
            return this;
        }

        PreAnalysisResult withFieldNames(Set<String> newFields) {
            return new PreAnalysisResult(this.indices(), this.lookupIndices(), this.enrichResolution(), newFields, this.wildcardJoinIndices(), this.inferenceResolution());
        }

        public PreAnalysisResult withWildcardJoinIndices(Set<String> wildcardJoinIndices) {
            return new PreAnalysisResult(this.indices(), this.lookupIndices(), this.enrichResolution(), this.fieldNames(), wildcardJoinIndices, this.inferenceResolution());
        }
    }
}

