/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.physical.local;

import java.util.ArrayList;
import java.util.Iterator;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EsSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class ReplaceSourceAttributes
extends PhysicalOptimizerRules.OptimizerRule<EsSourceExec> {
    public ReplaceSourceAttributes() {
        super(OptimizerRules.TransformDirection.UP);
    }

    @Override
    protected PhysicalPlan rule(EsSourceExec plan) {
        FieldAttribute docId = new FieldAttribute(plan.source(), EsQueryExec.DOC_ID_FIELD.getName(), EsQueryExec.DOC_ID_FIELD);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add((Attribute)docId);
        Iterator<Attribute> outputIterator = plan.output().iterator();
        boolean isTimeSeries = plan.indexMode() == IndexMode.TIME_SERIES;
        boolean keepIterating = true;
        Attribute tsid = null;
        Attribute timestamp = null;
        Attribute score = null;
        while (keepIterating && outputIterator.hasNext()) {
            Attribute attr = outputIterator.next();
            if (attr instanceof MetadataAttribute) {
                MetadataAttribute ma = (MetadataAttribute)attr;
                if (ma.name().equals("_score")) {
                    score = attr;
                } else if (isTimeSeries && ma.name().equals("_tsid")) {
                    tsid = attr;
                }
            } else if (attr.name().equals("@timestamp")) {
                timestamp = attr;
            }
            keepIterating = score == null || isTimeSeries && (tsid == null || timestamp == null);
        }
        if (isTimeSeries) {
            if (tsid == null || timestamp == null) {
                throw new IllegalStateException("_tsid or @timestamp are missing from the time-series source");
            }
            attributes.add(tsid);
            attributes.add(timestamp);
        }
        if (score != null) {
            attributes.add(score);
        }
        return new EsQueryExec(plan.source(), plan.indexPattern(), plan.indexMode(), plan.indexNameWithModes(), attributes, plan.query());
    }
}

