/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.RestRequest;

public final class RestCompatibilityChecker {
    private RestCompatibilityChecker() {
    }

    public static <T> void checkAndSetDeprecatedParam(String deprecatedParam, String newParam, RestApiVersion compatVersion, RestRequest restRequest, BiFunction<RestRequest, String, T> extractor, Consumer<T> setter) {
        T paramValue;
        if (restRequest.getRestApiVersion() == compatVersion && restRequest.hasParam(deprecatedParam)) {
            LoggingDeprecationHandler.INSTANCE.logRenamedField(null, () -> null, deprecatedParam, newParam, true);
            paramValue = extractor.apply(restRequest, deprecatedParam);
        } else {
            paramValue = extractor.apply(restRequest, newParam);
        }
        setter.accept(paramValue);
    }
}

