/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.snmp.mib;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.snmp.mib.OidData;
import org.snmp4j.smi.OID;

class OidTrie {
    private static final Logger logger = LogManager.getLogger(OidTrie.class);
    private final OidTrieNode root = new OidTrieNode(0);

    OidTrie() {
    }

    void insert(OID oid, OidData data) {
        int[] oidIdentifiers = oid.getValue();
        Map<Integer, OidTrieNode> current = this.root.getChildren();
        for (int i = 0; i < oidIdentifiers.length; ++i) {
            OidTrieNode node;
            int oidIdentifier = oidIdentifiers[i];
            if (current.containsKey(oidIdentifier)) {
                node = current.get(oidIdentifier);
            } else {
                node = new OidTrieNode(oidIdentifier);
                current.put(oidIdentifier, node);
            }
            current = node.getChildren();
            if (i + 1 != oidIdentifiers.length) continue;
            if (!node.hasData()) {
                node.setData(data);
                continue;
            }
            if (node.getData().equalsIgnoreModuleName(data)) continue;
            logger.warn("warning: overwriting MIB OID '{}' and name '{}' with new name '{}' from module '{}'", (Object)oid, (Object)node.getData().getName(), (Object)data.getName(), (Object)data.getModuleName());
            node.setData(data);
        }
    }

    Optional<OidData> find(OID oid) {
        return this.find(oid, null);
    }

    Optional<OidData> find(OID oid, Consumer<OidTrieNode> edgesConsumer) {
        int[] oidIdentifiers;
        OidTrieNode current = this.root;
        for (int identifier : oidIdentifiers = oid.getValue()) {
            OidTrieNode node = current.getChildren().get(identifier);
            if (node == null) {
                return Optional.empty();
            }
            if (edgesConsumer != null) {
                edgesConsumer.accept(node);
            }
            current = node;
        }
        if (current.hasData()) {
            return Optional.ofNullable(current.getData());
        }
        return Optional.empty();
    }

    static class OidTrieNode {
        private final int identifier;
        private final HashMap<Integer, OidTrieNode> children = new HashMap();
        private OidData data;

        public OidTrieNode(int identifier) {
            this.identifier = identifier;
        }

        int getIdentifier() {
            return this.identifier;
        }

        Map<Integer, OidTrieNode> getChildren() {
            return this.children;
        }

        OidData getData() {
            return this.data;
        }

        void setData(OidData data) {
            this.data = data;
        }

        boolean hasData() {
            return Objects.nonNull(this.data);
        }
    }
}

