/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.restriction;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.core.security.authz.restriction.Workflow;

public final class WorkflowResolver {
    private static final Logger logger = LogManager.getLogger(WorkflowResolver.class);
    public static final Workflow SEARCH_APPLICATION_QUERY_WORKFLOW = Workflow.builder().name("search_application_query").addAllowedRestHandlers("search_application_query_action").build();
    private static final Set<Workflow> ALL_WORKFLOWS = Set.of(SEARCH_APPLICATION_QUERY_WORKFLOW);
    private static final Map<String, Workflow> WORKFLOW_LOOKUP_MAP_BY_REST_HANDLER;
    private static final Map<String, Workflow> WORKFLOW_LOOKUP_MAP_BY_NAME;

    public static Set<Workflow> allWorkflows() {
        return ALL_WORKFLOWS;
    }

    public static Workflow resolveWorkflowByName(String name) {
        String filteredName = Objects.requireNonNull(name);
        Workflow resolvedWorkflow = WORKFLOW_LOOKUP_MAP_BY_NAME.get(filteredName);
        if (resolvedWorkflow != null) {
            return resolvedWorkflow;
        }
        String errorMessage = "Unknown workflow [" + name + "]. A workflow must be one of the predefined workflow names [" + Strings.collectionToCommaDelimitedString(WORKFLOW_LOOKUP_MAP_BY_NAME.keySet()) + "].";
        logger.debug(errorMessage);
        throw new IllegalArgumentException(errorMessage);
    }

    public static Workflow resolveWorkflowForRestHandler(String restHandler) {
        return WORKFLOW_LOOKUP_MAP_BY_REST_HANDLER.get(restHandler);
    }

    private WorkflowResolver() {
        throw new IllegalAccessError("not permitted");
    }

    static {
        HashMap<String, Workflow> lookupByName = new HashMap<String, Workflow>(ALL_WORKFLOWS.size());
        HashMap<String, Workflow> lookupByRestHandler = new HashMap<String, Workflow>();
        for (Workflow workflow : ALL_WORKFLOWS) {
            assert (!lookupByName.containsKey(workflow.name())) : "Workflow names must be unique. Workflow with the name [" + workflow.name() + "] has been defined more than once.";
            lookupByName.put(workflow.name(), workflow);
            for (String restHandler : workflow.allowedRestHandlers()) {
                assert (!lookupByRestHandler.containsKey(restHandler)) : "REST handler must belong to a single workflow. REST handler with the name [" + restHandler + "] has been assigned to more than one workflow.";
                lookupByRestHandler.put(restHandler, workflow);
            }
        }
        WORKFLOW_LOOKUP_MAP_BY_NAME = Map.copyOf(lookupByName);
        WORKFLOW_LOOKUP_MAP_BY_REST_HANDLER = Map.copyOf(lookupByRestHandler);
    }
}

