/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.enrollment;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public final class KibanaEnrollmentResponse
extends ActionResponse
implements ToXContentObject {
    private final String tokenName;
    private final SecureString tokenValue;
    private final String httpCa;

    public KibanaEnrollmentResponse(StreamInput in) throws IOException {
        this.tokenName = in.readString();
        this.tokenValue = in.readSecureString();
        this.httpCa = in.readString();
    }

    public KibanaEnrollmentResponse(String tokenName, SecureString tokenValue, String httpCa) {
        this.tokenName = tokenName;
        this.tokenValue = tokenValue;
        this.httpCa = httpCa;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public SecureString getTokenValue() {
        return this.tokenValue;
    }

    public String getHttpCa() {
        return this.httpCa;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.tokenName);
        out.writeSecureString(this.tokenValue);
        out.writeString(this.httpCa);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KibanaEnrollmentResponse that = (KibanaEnrollmentResponse)o;
        return this.tokenName.equals(that.tokenName) && this.tokenValue.equals(that.tokenValue) && this.httpCa.equals(that.httpCa);
    }

    public int hashCode() {
        return Objects.hash(this.tokenName, this.tokenValue, this.httpCa);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().startObject("token").field("name", this.tokenName).field("value", this.tokenValue.toString()).endObject().field("http_ca", this.httpCa).endObject();
        return builder;
    }
}

