/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.downsample;

import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record DownsampleBulkInfo(long totalBulkCount, long bulkIngestSumMillis, long maxBulkIngestMillis, long minBulkIngestMillis, long bulkTookSumMillis, long maxBulkTookMillis, long minBulkTookMillis) implements NamedWriteable,
ToXContentObject
{
    public static final String NAME = "rollup_bulk_info";
    private static final ParseField TOTAL_BULK_COUNT = new ParseField("total_bulk_count", new String[0]);
    private static final ParseField BULK_INGEST_SUM_MILLIS = new ParseField("bulk_ingest_sum_millis", new String[0]);
    private static final ParseField MAX_BULK_INGEST_MILLIS = new ParseField("max_bulk_ingest_millis", new String[0]);
    private static final ParseField MIN_BULK_INGEST_MILLIS = new ParseField("min_bulk_ingest_millis", new String[0]);
    private static final ParseField BULK_TOOK_SUM_MILLIS = new ParseField("bulk_took_sum_millis", new String[0]);
    private static final ParseField MAX_BULK_TOOK_MILLIS = new ParseField("max_bulk_took_millis", new String[0]);
    private static final ParseField MIN_BULK_TOOK_MILLIS = new ParseField("min_bulk_took_millis", new String[0]);
    private static final ConstructingObjectParser<DownsampleBulkInfo, Void> PARSER = new ConstructingObjectParser("rollup_bulk_info", args -> new DownsampleBulkInfo((Long)args[0], (Long)args[1], (Long)args[2], (Long)args[3], (Long)args[4], (Long)args[5], (Long)args[6]));

    public DownsampleBulkInfo(StreamInput in) throws IOException {
        this(in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong());
    }

    public static DownsampleBulkInfo fromXContext(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(TOTAL_BULK_COUNT.getPreferredName(), this.totalBulkCount);
        builder.field(BULK_INGEST_SUM_MILLIS.getPreferredName(), this.bulkIngestSumMillis);
        builder.field(MAX_BULK_INGEST_MILLIS.getPreferredName(), this.maxBulkIngestMillis);
        builder.field(MIN_BULK_INGEST_MILLIS.getPreferredName(), this.minBulkIngestMillis);
        builder.field(BULK_TOOK_SUM_MILLIS.getPreferredName(), this.bulkTookSumMillis);
        builder.field(MAX_BULK_TOOK_MILLIS.getPreferredName(), this.maxBulkTookMillis);
        builder.field(MIN_BULK_TOOK_MILLIS.getPreferredName(), this.minBulkTookMillis);
        return builder.endObject();
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.totalBulkCount);
        out.writeVLong(this.bulkIngestSumMillis);
        out.writeVLong(this.maxBulkIngestMillis);
        out.writeVLong(this.minBulkIngestMillis);
        out.writeVLong(this.bulkTookSumMillis);
        out.writeVLong(this.maxBulkTookMillis);
        out.writeVLong(this.minBulkTookMillis);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), TOTAL_BULK_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), BULK_INGEST_SUM_MILLIS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), MAX_BULK_INGEST_MILLIS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), MIN_BULK_INGEST_MILLIS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), BULK_TOOK_SUM_MILLIS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), MAX_BULK_TOOK_MILLIS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), MIN_BULK_TOOK_MILLIS);
    }
}

